% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{manip_channel}
\alias{manip_channel}
\alias{set_channel}
\alias{add_to_channel}
\alias{multiply_channel}
\alias{raise_channel}
\alias{cap_channel}
\alias{get_channel}
\title{Modify colour space channels in hex-encoded colour strings}
\usage{
set_channel(colour, channel, value, space = "rgb", white = "D65")

add_to_channel(colour, channel, value, space = "rgb", white = "D65")

multiply_channel(colour, channel, value, space = "rgb", white = "D65")

raise_channel(colour, channel, value, space = "rgb", white = "D65")

cap_channel(colour, channel, value, space = "rgb", white = "D65")

get_channel(colour, channel, space = "rgb", white = "D65")
}
\arguments{
\item{colour}{A character string giving colours, either as hexadecimal
strings or accepted colour names.}

\item{channel}{The channel to modify or extract as a single letter, or
\code{'alpha'} for the alpha channel.}

\item{value}{The value to modify with}

\item{space}{The colour space the channel pertains to. Allowed values are:
\code{"cmy"}, \code{"cmyk"}, \code{"hsl"}, \code{"hsb"}, \code{"hsv"}, \code{"lab"} (CIE L*ab), \code{"hunterlab"}
(Hunter Lab), \code{"lch"} (CIE Lch(ab) / polarLAB), \code{"luv"}, \code{"rgb"} (sRGB),
\code{"xyz"}, \code{"yxy"} (CIE xyY), or \code{"hcl"} (CIE Lch(uv) / polarLuv)}

\item{white}{The white reference of the channel colour space. Will only have
an effect for relative colour spaces such as Lab and luv. Any value accepted
by \code{\link[=as_white_ref]{as_white_ref()}} allowed.}
}
\value{
A character vector of the same length as \code{colour} (or a numeric
vector in the case of \code{get_channel()})
}
\description{
This set of functions allows you to modify colours as given by strings,
whithout first decoding them. For large vectors of colour values this should
provide a considerable speedup.
}
\examples{
spectrum <- rainbow(10)

# set a specific channel
set_channel(spectrum, 'r', c(10, 50))
set_channel(spectrum, 'l', 50, space = 'lab')
set_channel(spectrum, 'alpha', c(0.5, 1))

# Add value to channel
add_to_channel(spectrum, 'r', c(10, 50))
add_to_channel(spectrum, 'l', 50, space = 'lab')

# Multiply a channel
multiply_channel(spectrum, 'r', c(10, 50))
multiply_channel(spectrum, 'l', 50, space = 'lab')

# set a lower bound on a channel
raise_channel(spectrum, 'r', c(10, 50))
raise_channel(spectrum, 'l', 20, space = 'lab')

# set an upper bound on a channel
cap_channel(spectrum, 'r', c(100, 50))
cap_channel(spectrum, 'l', 20, space = 'lab')

}
\seealso{
Other encoding and decoding functions: \code{\link{decode_colour}},
  \code{\link{encode_colour}}
}
\concept{encoding and decoding functions}
