% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_flow_data.R
\name{plot_flow_data}
\alias{plot_flow_data}
\title{Plot daily mean streamflow}
\usage{
plot_flow_data(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  roll_days = 1,
  roll_align = "right",
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  start_date,
  end_date,
  log_discharge = FALSE,
  plot_by_year = FALSE,
  one_plot = FALSE,
  include_title = FALSE
)
}
\arguments{
\item{data}{A data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank if using \code{station_number} argument.}

\item{dates}{Column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not '
Date' (default). Leave blank if using \code{station_number} argument.}

\item{values}{Column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required if
groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if present.
Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} argument.}

\item{station_number}{A character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{roll_days}{Numeric value of the number of days to apply a rolling mean. Default \code{1}.}

\item{roll_align}{Character string identifying the direction of the rolling mean from the specified date, either by the first 
('left'), last ('right), or middle ('center') day of the rolling n-day group of observations. Default \code{'right'}.}

\item{water_year_start}{Numeric value indicating the month of the start of the water year for analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank to use the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank to use the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank to include all years.}

\item{start_date}{Date (YYYY-MM-DD) of first date to consider for plotting. Leave blank if all years are required.}

\item{end_date}{Date (YYYY-MM-DD) of last date to consider for plotting. Leave blank if all years are required.}

\item{log_discharge}{Logical value to indicate plotting the discharge axis (Y-axis) on a logarithmic scale. Default \code{TRUE}.}

\item{plot_by_year}{Logical value to indicate whether to plot each year of data individually. Default \code{FALSE}.}

\item{one_plot}{Logical value to indicate whether to plot all groups/stations on one plot. Default \code{FALSE}.}

\item{include_title}{Logical value to indicate adding the group/station number to the plot, if provided. Default \code{FALSE}.}
}
\value{
A ggplot2 object of daily flows from flow_data or HYDAT flow data provided
}
\description{
Plot the daily mean flow values from a streamflow dataset. Plots the statistics from all daily discharge values from all 
   years, unless specified. Can choose specific dates to start and end plotting. Can choose to plot out each year separately. Data 
   calculated using calc_daily_stats() function. Multiple groups/stations can be plotted if provided with the \code{groups} argument.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Plot data from a data frame and data argument
flow_data <- tidyhydat::hy_daily_flows(station_number = "08NM116")
plot_flow_data(data = flow_data)

# Plot data directly from HYDAT
plot_flow_data(station_number = "08NM116")

# Plot statistics with custom years
plot_flow_data(station_number = "08NM116",
               start_year = 1981,
               end_year = 2010,
               exclude_years = c(1991,1993:1995))
                 
# Plot data between specific dates
plot_flow_data(station_number = "08NM116",
               start_date = "1990-01-01",
               end_date = "1990-06-01")

# Plot data multiple groups on one plot
plot_flow_data(station_number = c("08NM241", "08NM242"),
               one_plot = TRUE) 
               
}
}
