% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_basin_area.R
\name{add_basin_area}
\alias{add_basin_area}
\title{Add a basin area column to daily flows}
\usage{
add_basin_area(data, groups = STATION_NUMBER, station_number, basin_area)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{basin_area}{Upstream drainage basin area, in square kilometres, to apply to observations. Three options:

(1) Leave blank if \code{groups} is STATION_NUMBER with HYDAT station numbers to extract basin areas from HYDAT.

(2) A single numeric value to apply to all observations.

(3) List each basin area for each group/station in groups (can override HYDAT value if listed) as such \code{c("08NM116" = 795, 
"08NM242" = 10)}. If group is not listed the HYDAT area will be applied if it exists, otherwise it will be \code{NA}.}
}
\value{
A tibble data frame of the original source data with an additional column:
  \item{Basin_Area_sqkm}{area of upstream drainage basin area, in square kilometres}
}
\description{
Add a column of basin areas to a daily streamflow data set, in units of square kilometres.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Add the HYDAT basin area to a data frame with station numbers
flow_data <- tidyhydat::hy_daily_flows(station_number = "08NM116")
add_basin_area(data = flow_data)

# Add the HYDAT basin area to data from HYDAT
add_basin_area(station_number = "08NM116")

# Set a custom basin area
add_basin_area(station_number = "08NM116",
               basin_area = 800)
               
# Set multiple custom basin areas for multiple stations
add_basin_area(station_number = c("08NM116", "08NM242"),
               basin_area = c("08NM116" = 800, "08NM242" = 10))

}         
}
