% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_longterm_monthly_stats.R
\name{plot_longterm_monthly_stats}
\alias{plot_longterm_monthly_stats}
\title{Plot long-term summary statistics from annual monthly mean flows}
\usage{
plot_longterm_monthly_stats(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  roll_days = 1,
  roll_align = "right",
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  months = 1:12,
  complete_years = FALSE,
  ignore_missing = FALSE,
  include_extremes = TRUE,
  inner_percentiles = c(25, 75),
  outer_percentiles = c(5, 95),
  add_year,
  log_discharge = TRUE,
  include_title = FALSE
)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{roll_days}{Numeric value of the number of days to apply a rolling mean. Default \code{1}.}

\item{roll_align}{Character string identifying the direction of the rolling mean from the specified date, either by the first 
(\code{'left'}), last (\code{'right'}), or middle (\code{'center'}) day of the rolling n-day group of observations. 
Default \code{'right'}.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank to use the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank to use the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank to include all years.}

\item{months}{Numeric vector of months to include in analysis (e.g. \code{6:8} for Jun-Aug). Leave blank to summarize 
all months (default \code{1:12}).}

\item{complete_years}{Logical values indicating whether to include only years with complete data in analysis. Default \code{FALSE}.}

\item{ignore_missing}{Logical value indicating whether dates with missing values should be included in the calculation. If
\code{TRUE} then a statistic will be calculated regardless of missing dates. If \code{FALSE} then only those statistics from
time periods with no missing dates will be returned. Default \code{FALSE}.}

\item{include_extremes}{Logical value to indicate plotting a ribbon with the range of daily minimum and maximum flows. 
Default \code{TRUE}.}

\item{inner_percentiles}{Numeric vector of two percentile values indicating the lower and upper limits of the 
inner percentiles ribbon for plotting. Default \code{c(25,75)}, set to \code{NULL} for no inner ribbon.}

\item{outer_percentiles}{Numeric vector of two percentile values indicating the lower and upper limits of the 
outer percentiles ribbon for plotting. Default \code{c(5,95)}, set to \code{NULL} for no outer ribbon.}

\item{add_year}{Numeric value indicating a year of daily flows to add to the daily statistics plot. Leave blank for no years.}

\item{log_discharge}{Logical value to indicate plotting the discharge axis (Y-axis) on a logarithmic scale. Default \code{FALSE}.}

\item{include_title}{Logical value to indicate adding the group/station number to the plot, if provided. Default \code{FALSE}.}
}
\value{
A list of ggplot2 objects with the following for each station provided:
  \item{Long-term_Monthly_Statistics}{a plot that contains long-term flow statistics}
  Default plots on each object:  
  \item{Monthly Mean}{mean of all annual monthly means for a given month over all years}
  \item{Monthly Median}{median of all annual monthly means for a given month over all years}
  \item{25-75 Percentiles Range}{a ribbon showing the range of data between the monthly 25th and 75th percentiles}
  \item{5-95 Percentiles Range}{a ribbon showing the range of data between the monthly 5th and 95th percentiles}
  \item{Max-Min Range}{a ribbon showing the range of data between the monthly minimum and maximums}
}
\description{
Plots the long-term mean, median, maximum, minimum, and percentiles of annual monthly mean flow values for all
   months and all data (Long-term) from a daily streamflow data set. Calculates statistics from all values, unless specified. 
   The Maximum-Minimum band can be removed using the \code{include_extremes} argument and the percentile bands 
   can be customized using the \code{inner_percentiles} and \code{outer_percentiles} arguments. Data calculated using the 
   \code{calc_longterm_monthly_stats()} function. Returns a list of plots.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Plot longterm monthly statistics using data argument with defaults
flow_data <- tidyhydat::hy_daily_flows(station_number = "08NM116")
plot_longterm_monthly_stats(data = flow_data,
                            start_year = 1980)

# Plot longterm monthly statistics using station_number argument with defaults
plot_longterm_monthly_stats(station_number = "08NM116",
                            start_year = 1980)
            
# Plot longterm monthly statistics and add a specific year's daily flows                
plot_longterm_monthly_stats(station_number = "08NM116",
                            start_year = 1980,
                            add_year = 1985) 
                              
                            
}
}
\seealso{
\code{\link{calc_longterm_monthly_stats}}
}
