% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{eigen_compute_single_entry_of_diagonal_matrix}
\alias{eigen_compute_single_entry_of_diagonal_matrix}
\title{Compute Single Value of the Diagonal of a Symmetric Matrix's Inverse}
\usage{
eigen_compute_single_entry_of_diagonal_matrix(M, j, num_cores = 1)
}
\arguments{
\item{M}{The symmetric matrix which to invert (and then extract one element of its diagonal)}

\item{j}{The diagonal entry of \code{M}'s inverse}

\item{num_cores}{The number of cores to use. Default is 1.}
}
\value{
The value of m^{-1}_{j,j}
}
\description{
Via the eigen package's conjugate gradient descent algorithm.
}
\examples{
	n = 500
	X = matrix(rnorm(n^2), nrow = n, ncol = n)
	M = t(X) \%*\% X
	j = 137
	eigen_compute_single_entry_of_diagonal_matrix(M, j)
	solve(M)[j, j] #to ensure it's the same value
}
\author{
Adam Kapelner
}
