% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qrridge_cv}
\alias{qrridge_cv}
\title{Cross-validation of the RIDGE estimator for the linear regression model}
\arguments{
\item{y}{a vector of length-\eqn{n} response vector.}

\item{X}{an \eqn{(n\times p)} full column rank matrix of predictors.}

\item{lambda}{a vector of lambdas.}

\item{k}{an integer vector defining the number of groups for CV.}

\item{seed}{ad integer number defining the seed for random number generation.}

\item{X_test}{an \eqn{(q\times p)} full column rank matrix. Test set. By default it set to NULL.}

\item{type}{either "QR" or "R". Specifies the type of decomposition to use: "QR" for the QR decomposition or "R" for the Cholesky factorization of \eqn{A^\top A}. The default is "QR".}
}
\value{
A named list containing \describe{
\item{coeff}{a length-\eqn{p} vector containing the solution for the parameters \eqn{\beta}.}
\item{fitted}{a length-\eqn{n} vector of fitted values, \eqn{\widehat{y}=X\widehat{\beta}}.}
\item{residuals}{a length-\eqn{n} vector of residuals, \eqn{\varepsilon=y-\widehat{y}}.}
\item{residuals_norm2}{the L2-norm of the residuals, \eqn{\Vert\varepsilon\Vert_2^2.}}
\item{y_norm2}{the L2-norm of the response variable. \eqn{\Vert y\Vert_2^2.}}
\item{XTX}{the matrix \eqn{X^\top X}.}
\item{XTy}{\eqn{X^\top y}.}
\item{sigma_hat}{estimated  residual variance.}
\item{df}{degrees of freedom.}
\item{Q}{\eqn{Q} matrix of the QR decomposition of the matrix \eqn{X^\top X}.}
\item{R}{\eqn{R} matrix of the QR decomposition of the matrix \eqn{X^\top X}.}
\item{QXTy}{\eqn{QX^\top y}, where \eqn{Q} matrix of the QR decomposition of the matrix \eqn{X^\top X}.}
\item{R2}{\eqn{R^2}, coefficient of determination, measure of goodness-of-fit of the model.}
\item{predicted}{predicted values for the test set, \eqn{X_{\text{test}}\widehat{\beta}}. It is only available if X_test is not NULL.}
}
}
\description{
qrridge_cv, or LS for linear multivariate regression models, solves the following optimization problem
\deqn{\textrm{min}_\beta ~ \frac{1}{2}\|Y-XB\|_2^2,}
for \eqn{Y\in\mathbb{R}^{n \times q}} and \eqn{X\in\mathbb{R}^{n\times p}}, to obtain a coefficient matrix \eqn{\widehat{B}\in\mathbb{R}^{p\times q}}. The design matrix \eqn{X\in\mathbb{R}^{n\times p}}
contains the observations for each regressor.
}
\examples{

## generate sample data
set.seed(10)
n         <- 30
p         <- 6
X         <- matrix(rnorm(n * p, 1), n, p)
X[,1]     <- 1
eps       <- rnorm(n)
beta      <- rep(1, p)
y         <- X \%*\% beta + eps
X_test    <- matrix(rnorm(5 * p, 1), 5, p)
output    <- fastQR::qrridge_cv(y = y, X = X, lambda = c(1,2), 
                                k = 5, seed = 12, X_test = X_test, type = "QR")
output$coeff

}
