% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_pbp.R
\name{load_nhl_schedule}
\alias{load_nhl_schedule}
\title{\strong{Load fastRhockey NHL schedules}}
\usage{
load_nhl_schedule(
  seasons = most_recent_nhl_season(),
  ...,
  dbConnection = NULL,
  tablename = NULL
)
}
\arguments{
\item{seasons}{A vector of 4-digit years associated with given NHL seasons. (Min: 2011)}

\item{...}{Additional arguments passed to an underlying function that writes
the season data into a database (used by \code{update_nhl_db()}).}

\item{dbConnection}{A \code{DBIConnection} object, as returned by \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{tablename}{The name of the schedule data table within the database}
}
\value{
Returns a tibble
}
\description{
helper that loads multiple seasons from the data repo either into memory
or writes it into a db using some forwarded arguments in the dots
}
\examples{
\donttest{
  try(load_nhl_schedule(2021))
}
}
