test_that("NHL - Get NHL Teams Stats", {
  skip_on_cran()
  x <- nhl_teams_stats(team_id=14)

  cols <- c("team_id",
            "team_name",
            "team_link",
            "season_type_id",
            "season_type_description",
            "season_type_postseason",
            "games_played",
            "wins",
            "losses",
            "ot",
            "pts",
            "pt_pctg",
            "goals_per_game",
            "goals_against_per_game",
            "ev_gga_ratio",
            "power_play_percentage",
            "power_play_goals",
            "power_play_goals_against",
            "power_play_opportunities",
            "penalty_kill_percentage",
            "shots_per_game",
            "shots_allowed",
            "win_score_first",
            "win_opp_score_first",
            "win_lead_first_per",
            "win_lead_second_per",
            "win_outshoot_opp",
            "win_outshot_by_opp",
            "face_offs_taken",
            "face_offs_won",
            "face_offs_lost",
            "face_off_win_percentage",
            "shooting_pctg",
            "save_pctg",
            "wins_rank",
            "losses_rank",
            "ot_rank",
            "pts_rank",
            "pt_pctg_rank",
            "goals_per_game_rank",
            "goals_against_per_game_rank",
            "ev_gga_ratio_rank",
            "power_play_percentage_rank",
            "power_play_goals_rank",
            "power_play_goals_against_rank",
            "power_play_opportunities_rank",
            "penalty_kill_opportunities_rank",
            "penalty_kill_percentage_rank",
            "shots_per_game_rank",
            "shots_allowed_rank",
            "win_score_first_rank",
            "win_opp_score_first_rank",
            "win_lead_first_per_rank",
            "win_lead_second_per_rank",
            "win_outshoot_opp_rank",
            "win_outshot_by_opp_rank",
            "face_offs_taken_rank",
            "face_offs_won_rank",
            "face_offs_lost_rank",
            "face_off_win_percentage_rank",
            "save_pct_rank_rank",
            "shooting_pct_rank_rank",
            "season")

  expect_equal(colnames(x), cols)
  expect_s3_class(x, 'data.frame')

})
