% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GAN.R
\name{GANLearner_wgan}
\alias{GANLearner_wgan}
\title{Wgan}
\usage{
GANLearner_wgan(
  dls,
  generator,
  critic,
  switcher = NULL,
  clip = 0.01,
  switch_eval = FALSE,
  gen_first = FALSE,
  show_img = TRUE,
  cbs = NULL,
  metrics = NULL,
  opt_func = Adam(),
  lr = 0.001,
  splitter = trainable_params,
  path = NULL,
  model_dir = "models",
  wd = NULL,
  wd_bn_bias = FALSE,
  train_bn = TRUE,
  moms = list(0.95, 0.85, 0.95)
)
}
\arguments{
\item{dls}{dataloader}

\item{generator}{generator}

\item{critic}{critic}

\item{switcher}{switcher}

\item{clip}{clip value}

\item{switch_eval}{switch evaluation}

\item{gen_first}{generator first}

\item{show_img}{show image or not}

\item{cbs}{callbacks}

\item{metrics}{metrics}

\item{opt_func}{optimization function}

\item{lr}{learning rate}

\item{splitter}{splitter}

\item{path}{path}

\item{model_dir}{model directory}

\item{wd}{weight decay}

\item{wd_bn_bias}{weight decay bn bias}

\item{train_bn}{It controls if BatchNorm layers are trained even when they are supposed to be frozen according to the splitter.}

\item{moms}{momentums}
}
\value{
None
}
\description{
Create a WGAN from `data`, `generator` and `critic`.
}
\examples{
\dontrun{

learn = GANLearner_wgan(dls, generator, critic, opt_func = partial(Adam(), mom=0.))

}

}
