% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/makeSampleData.R
\name{makeSampleData}
\alias{makeSampleData}
\title{Create sample data for FastCMH}
\usage{
makeSampleData(folder = "./", xfilename = "data.txt",
  yfilename = "label.txt", covfilename = "cov.txt", K = 2, L = 1000,
  n = 200, noiseP = 0.3, corruptP = 0.05, rho = 0.8, tau1 = 100,
  taulength1 = 4, tau2 = 200, taulength2 = 4, seednum = 2,
  truetaufilename = "truetau.txt", showOutput = FALSE)
}
\arguments{
\item{folder}{The folder in which the data will be saved. Default is current directory "./".}

\item{xfilename}{The name of the data file. Default is "data.txt".}

\item{yfilename}{The name of the label file. Default is "label.txt".}

\item{covfilename}{The name of the file containing the covariate categories. This file actually just contains K numbers, where K is the number of covariates. Default is "cov.txt".}

\item{K}{The number of covariates (a positive integer). Default is K=2.}

\item{L}{The number of features (length of each sequence). Default is L=1000.}

\item{n}{The number of samples (cases and controls combined). Default is n=200, i.e. 100 cases and 100 controls.}

\item{noiseP}{The background noise in the data (as a probability of 0/1 being flipped). Default is noiseP=0.3.}

\item{corruptP}{The probability of data corruption: each bit has probability correuptP of being flipped. Default is corruptP=0.05.}

\item{rho}{The strength of the confounding in the confounded interval (as a probability). Default is rho=0.8 (i.e. a very strong signal).}

\item{tau1}{The location of the significant interval (starting point). Default value is tau1=100.}

\item{taulength1}{The length of the significant interval. Default value is taulength1=4, so default significant interval is [100, 103].}

\item{tau2}{The location of the confounded significant interval (starting point). Default value is tau2=200.}

\item{taulength2}{The length of the confounded significant interval. Default value is taulength2=4, so default significant interval is [200, 203].}

\item{seednum}{The seed used for generating the data. Default value is sednum=2.}

\item{truetaufilename}{The file where the location of the true significant intervals are saved (as opposed to the detected significant intervals). Default is "truetau.txt".}

\item{showOutput}{Flag to decide whether or not to show output, where files are created, their names, etc. Default is FALSE}
}
\description{
This function creates sample data for use with the FastCMH method.
}
\section{See Also}{

'FastCMH'
}
\examples{
#make a small sample data set, using the default parameters
makeSampleData("~/sampledata/", showOutput=TRUE)

#make a very small sample data set
makeSampleData("~/sampledata/small/", n=20, L=10, tau1=2, taulength1=2, tau2=6, taulength2=2)
}

