% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellSize.r
\name{cellSize,GRaster-method}
\alias{cellSize,GRaster-method}
\alias{cellSize}
\title{Area of GRaster cells}
\usage{
\S4method{cellSize}{GRaster}(x, mask = FALSE, lyrs = FALSE, unit = "meters2")
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{mask}{Logical: If \code{TRUE}, then cells that are \code{NA} in \code{x} are also \code{NA} in the output.}

\item{lyrs}{Logical:
\itemize{
\item If \code{lyrs} is \code{FALSE} (default), then the output has a single layer. In this case, if \code{mask} is \code{TRUE}, then cells that are \code{NA} in the \emph{first} layer are also \code{NA} in the output.
\item If \code{lyrs} is \code{TRUE}, then the output has the same number of layers as \code{x} if \code{mask} is also \code{TRUE}. In this case, cells that area \code{NA} in the input will also be \code{NA} in the output in the respective layer.
}}

\item{unit}{Character: Units of area. Partial matching is used, and case is ignored. Can be any of:
\itemize{
\item \code{"meters2"} (default), \code{"metres2"}, or \code{"m2"}
\item \code{"km2"} or \code{"kilometers2"}
\item \code{"ha"} or \code{"hectares"}
\item \code{"ac"} or \code{"acres"}
\item \code{"mi2"} or \code{"miles2"}
\item \code{"ft2"} or \code{"feet2"}
}}
}
\value{
A \code{GRaster}.
}
\description{
\code{cellArea()} returns a raster will cell values equal to their area. To get the area of all cells of a raster, see \code{\link[=expanse]{expanse()}}.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Elevation raster
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster:
elev <- fast(madElev)

# Cell size, no masking, single layer
cs1 <- cellSize(elev)
plot(cs1)

# Cell size, with masking, single layer
cs2 <- cellSize(elev, mask = TRUE)
plot(cs2)

# Cell size, no masking, multilayer
elev2 <- c(elev, log(elev - 200))
cs3 <- cellSize(elev2)
plot(cs3)

# Cell size, masking by 1st layer, multilayer (ignores subsequent layers)
cs4 <- cellSize(elev2, mask = TRUE)
plot(cs4)

# Cell size, masking by each layer, multilayer
cs5 <- cellSize(elev2, mask = TRUE, lyrs = TRUE)
plot(cs5)

}
}
\seealso{
\code{\link[terra:cellSize]{terra::cellSize()}}, \code{\link[=expanse]{expanse()}}, \code{\link[=zonalGeog]{zonalGeog()}}, \code{\link[omnibus:convertUnits]{omnibus::convertUnits()}}
}
