% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segregate.r
\name{segregate,GRaster-method}
\alias{segregate,GRaster-method}
\alias{segregate}
\title{Create one GRaster layer per unique value in a GRaster}
\usage{
\S4method{segregate}{GRaster}(x, classes = NULL, keep = FALSE, other = 0, bins = 100, digits = 3)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{classes}{Either \code{NULL} (default) or a character vector with category labels for which to create outputs. If the input is not a categorical/factor or \code{integer} \code{GRaster}, this is ignored.}

\item{keep}{Logical: If \code{FALSE} (default), then the original value in the input \code{GRaster} will be retained in the each of the output \code{GRaster} layers wherever the input had the respective value. Other cells will be assigned a value of \code{other}.}

\item{other}{Numeric or \code{NA}: Value to assign to cells that do not have the target value.}

\item{bins}{Numeric: Number of bins in which to put values. This is only used for \code{GRaster}s that are not categorical/factor rasters or \code{integer} rasters.}

\item{digits}{Numeric: Number of digits to which to round input if it is a \code{numeric} or \code{double} \code{GRaster} (see \code{vignettes("GRasters", package = "fasterRaster")}).}
}
\value{
If the input \code{x} is a single-layered \code{GRaster}, the output will be a multi-layered \code{GRaster} with one layer per value in the input, or one layer per values in \code{classes}. If the input is a multi-layered \code{GRaster}, the output will be a \code{list} of multi-layered \code{GRaster}s.
}
\description{
This function creates a multi-layered \code{GRaster} for every unique values in an input \code{GRaster}. By default, the output will have a value of 1 wherever the input has the given value, and 0 elsewhere. This is useful for creating dummy variable \code{GRaster} layers for use with models that have factors, especially if the input \code{GRaster} is categorical. Note that the \code{\link[=predict]{predict()}} function in \strong{fasterRaster} usually does not need this treatment of \code{GRaster}s since it can handle categorical rasters already.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Elevation and land cover raster
madElev <- fastData("madElev") # integer raster
madCover <- fastData("madCover") # categorical raster

# Convert to GRasters
elev <- fast(madElev)
cover <- fast(madCover)

# Subset elevation raster to just a few values to make example faster:
elevSubset <- elev[elev <= 3]
segregate(elevSubset)
segregate(elevSubset, keep = TRUE, other = -1)

# Segregate the factor raster
segregate(cover)

classes <- c("Grassland with mosaic forest", "Mosaic cropland/vegetation")
seg <- segregate(cover, classes = classes)
plot(seg)

}
}
\seealso{
\code{\link[terra:segregate]{terra::segregate()}}
}
