% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erase.r
\name{erase,GVector,GVector-method}
\alias{erase,GVector,GVector-method}
\alias{erase}
\title{Select parts of a polygon GVector erase shared by another polygon GVector}
\usage{
\S4method{erase}{GVector,GVector}(x, y)
}
\arguments{
\item{x, y}{\code{GVector}s.}
}
\value{
A \code{GVector}.
}
\description{
The \code{erase()} function removes from the \code{x} "polygons" \code{GVector} parts that overlap with the \code{y} "polygons" \code{GVector}. You can also use the \code{-} operator (e.g., \code{vect1 - vect2}).
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Polygon of coastal Madagascar and Dypsis specimens
madCoast4 <- fastData("madCoast4") # polygons
madDypsis <- fastData("madDypsis") # points

# Convert vectors:
coast4 <- fast(madCoast4)
dypsis <- fast(madDypsis)

# Create another polygons vector from a convex hull around Dypsis points
hull <- convHull(dypsis)

### union()

unioned <- union(coast4, hull)
plot(unioned)

plus <- coast4 + hull # same as union()

### intersect

inter <- intersect(coast4, hull)
plot(coast4)
plot(hull, border = "red", add = TRUE)
plot(inter, border = "blue", add = TRUE)

### xor

xr <- xor(coast4, hull)
plot(coast4)
plot(xr, border = "blue", add = TRUE)

### erase

erased <- erase(coast4, hull)
plot(coast4)
plot(erased, border = "blue", add = TRUE)

minus <- coast4 - hull # same as erase()

}
}
\seealso{
\code{\link[=c]{c()}}, \code{\link[=aggregate]{aggregate()}}, \code{\link[=crop]{crop()}}, \code{\link[=intersect]{intersect()}}, \code{\link[=union]{union()}}, \code{\link[=xor]{xor()}}
}
