% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_glm.R
\name{fastglm}
\alias{fastglm}
\alias{fastglm.default}
\title{fast generalized linear model fitting}
\usage{
fastglm(x, ...)

\method{fastglm}{default}(x, y, family = gaussian(), weights = NULL,
  offset = NULL, start = NULL, etastart = NULL, mustart = NULL,
  method = 0L, tol = 1e-08, maxit = 100L, ...)
}
\arguments{
\item{x}{input model matrix. Must be a matrix object}

\item{...}{not used}

\item{y}{numeric response vector of length nobs.}

\item{family}{a description of the error distribution and link function to be used in the model. 
For \code{fastglm} this can be a character string naming a family function, a family function or the 
result of a call to a family function. For \code{fastglmPure} only the third option is supported. 
(See \code{\link[stats]{family}} for details of family functions.)}

\item{weights}{an optional vector of 'prior weights' to be used in the fitting process. Should be a numeric vector.}

\item{offset}{this can be used to specify an a priori known component to be included in the linear predictor during fitting. 
This should be a numeric vector of length equal to the number of cases}

\item{start}{starting values for the parameters in the linear predictor.}

\item{etastart}{starting values for the linear predictor.}

\item{mustart}{values for the vector of means.}

\item{method}{an integer scalar with value 0 for the column-pivoted QR decomposition, 1 for the unpivoted QR decomposition,
2 for the LLT Cholesky, or 3 for the LDLT Cholesky}

\item{tol}{threshold tolerance for convergence. Should be a positive real number}

\item{maxit}{maximum number of IRLS iterations. Should be an integer}
}
\value{
A list with the elements
\item{coefficients}{a vector of coefficients}
\item{se}{a vector of the standard errors of the coefficient estimates}
\item{rank}{a scalar denoting the computed rank of the model matrix}
\item{df.residual}{a scalar denoting the degrees of freedom in the model}
\item{residuals}{the vector of residuals}
\item{s}{a numeric scalar - the root mean square for residuals}
\item{fitted.values}{the vector of fitted values}
}
\description{
fast generalized linear model fitting

bigLm default
}
\examples{

x <- matrix(rnorm(10000 * 100), ncol = 100)
y <- 1 * (0.25 * x[,1] - 0.25 * x[,3] > rnorm(10000))

system.time(gl1 <- glm.fit(x, y, family = binomial()))

system.time(gf1 <- fastglm(x, y, family = binomial()))

system.time(gf2 <- fastglm(x, y, family = binomial(), method = 1))

system.time(gf3 <- fastglm(x, y, family = binomial(), method = 2))

system.time(gf4 <- fastglm(x, y, family = binomial(), method = 3))

max(abs(coef(gl1) - gf1$coef))
max(abs(coef(gl1) - gf2$coef))
max(abs(coef(gl1) - gf3$coef))
max(abs(coef(gl1) - gf4$coef))


}
