% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_summarise.R
\name{f_summarise}
\alias{f_summarise}
\alias{f_summarize}
\title{Summarise each group down to one row}
\usage{
f_summarise(data, ..., .by = NULL, .optimise = TRUE)

f_summarize(data, ..., .by = NULL, .optimise = TRUE)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Name-value pairs of summary functions. Expressions with
\code{across()} are also accepted.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{.optimise}{(Optionally) turn off optimisations for common statistical
functions by setting to \code{FALSE}. Default is \code{TRUE} which uses optimisations.}
}
\value{
An un-grouped data frame of summaries by group.
}
\description{
Like \code{dplyr::summarise()} but with some internal optimisations
for common statistical functions.
}
\details{
\code{f_summarise} behaves mostly like \code{dplyr::summarise} except that expressions
supplied to \code{...} are evaluated independently.
\subsection{Optimised statistical functions}{

Some functions are internally optimised using 'collapse'
fast statistical functions. This makes execution on many groups very fast.

For fast quantiles (percentiles) by group, see \link{tidy_quantiles}

List of currently optimised functions and their equivalent
'collapse' function

\code{base::sum} -> \code{collapse::fsum} \cr
\code{base::prod} -> \code{collapse::fprod} \cr
\code{base::min} -> \code{collapse::fmin} \cr
\code{base::max} -> \code{collapse::fmax} \cr
\code{stats::mean} -> \code{collapse::fmean} \cr
\code{stats::sd} -> \code{collapse::fsd} \cr
\code{stats::var} -> \code{collapse::fvar} \cr
\code{dplyr::first} -> \code{collapse::ffirst} \cr
\code{dplyr::last} -> \code{collapse::flast} \cr
\code{dplyr::n_distinct} -> \code{collapse::fndistinct} \cr
}
}
\examples{
library(fastplyr)
library(nycflights13)

# Number of flights per month, including first and last day
flights \%>\%
  f_group_by(year, month) \%>\%
  f_summarise(first_day = first(day),
              last_day = last(day),
              num_flights = n())

## Fast mean summary using `across()`

flights \%>\%
  f_summarise(
    across(where(is.double), mean),
    .by = tailnum
  )

# To ignore or keep NAs, use collapse::set_collapse(na.rm)
collapse::set_collapse(na.rm = FALSE)
flights \%>\%
  f_summarise(
    across(where(is.double), mean),
    .by = origin
  )
collapse::set_collapse(na.rm = TRUE)
}
\seealso{
\link{tidy_quantiles}
}
