% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fbroc.methods.R
\name{plot.fbroc.perf}
\alias{plot.fbroc.perf}
\title{Plots ROC based performance metric as histogram}
\usage{
\method{plot}{fbroc.perf}(x, bins = NULL, col = "white",
  fill = "lightblue", print.plot = TRUE, show.conf = TRUE,
  conf.text = TRUE, ...)
}
\arguments{
\item{x}{Object of class \code{perf.roc} to be plotted.}

\item{bins}{Number of bins for histogram. Default value depends on the number of bootstrap
values and the number of unique bootstrap performance values.}

\item{col}{Color of outline of histogram bars. Defaults to white.}

\item{fill}{Fill of histogram bars. Defaults to lightblue.}

\item{print.plot}{Logical specifying whether the plot should be printed.}

\item{show.conf}{Logical specifying whether the confidence interval
should be displayed.}

\item{conf.text}{Logical specifying whether the confidence interval limits
should also be displayed as text.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A ggplot, so that the user can customize the plot further.
}
\description{
Given an object of class \code{perf.roc} this function plots the results of
the bootstrap as an histogram. The confidence interval is also included by
default.
}
\examples{
y <- rep(c(TRUE, FALSE), each = 500)
x <- rnorm(1000) + y
result.boot <- boot.roc(x, y, n.boot = 10000)
result.perf <- perf.roc(result.boot, "auc")
plot(result.perf)
}
\seealso{
\code{\link{perf.roc}}
}

