% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{fct_impute}
\alias{fct_impute}
\title{Impute Missing Values in Factor Vector}
\usage{
fct_impute(factor_vec, method = "mode")
}
\arguments{
\item{factor_vec}{A factor vector with potential \code{NA} values.}

\item{method}{The imputation method: \code{'mode'}, \code{'random'}, or a user-defined function.}
}
\value{
A factor vector with \code{NA} values imputed.
}
\description{
Replaces \code{NA} values in a factor vector using specified imputation methods.
}
\examples{
# Example factor vector with NAs
factor_vec <- factor(c('apple', NA, 'banana', 'apple', NA))

# Impute using mode
fct_impute(factor_vec, method = 'mode')

# Impute using random selection
fct_impute(factor_vec, method = 'random')
}
\author{
Kai Guo
}
