% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_replace.R
\name{fct_replace_pattern}
\alias{fct_replace_pattern}
\title{Replace Parts of Factor Levels Based on a Pattern}
\usage{
fct_replace_pattern(factor_vec, pattern, replacement)
}
\arguments{
\item{factor_vec}{A factor vector to be modified.}

\item{pattern}{A regular expression pattern to match.}

\item{replacement}{A string to replace the matched parts.}
}
\value{
A factor vector with levels modified.
}
\description{
Replaces parts of the factor levels that match a specified pattern with a new string.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple_pie', 'banana_bread', 'cherry_cake'))

# Replace '_pie', '_bread', '_cake' with '_dessert'
fct_replace_pattern(factor_vec, pattern = '_.*', replacement = '_dessert')
}
\author{
Kai Guo
}
