% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DE_init.R
\name{DE.heat.FEM}
\alias{DE.heat.FEM}
\title{Density initialization}
\usage{
DE.heat.FEM(data, FEMbasis, lambda=NULL, heatStep=0.1, heatIter=500, 
            init="Heat", nFolds=5, search = "tree")
}
\arguments{
\item{data}{A matrix of dimensions #observations-by-ndim. Data are locations: each row corresponds to one point, 
the first column corresponds to the \code{x}-coordinates, the second column corresponds to the \code{y}-coordinates 
and, if ndim=3, the third column corresponds to the \code{z}-coordinates.}

\item{FEMbasis}{A \code{FEMbasis} object describing the Finite Element basis, as created by \code{\link{create.FEM.basis}}.}

\item{lambda}{A scalar or vector of smoothing parameters. Default is NULL. It is useful only if \code{init='Heat'}.}

\item{heatStep}{Real specifying the time step for the discretized heat diffusionn process.}

\item{heatIter}{Integer specifying the number of iteriations to perform the discretized heat diffusion process.}

\item{init}{String. This parameter specifies the initialization procedure. It can be either 'Heat' or 'CV'.}

\item{nFolds}{An integer specifying the number of folds used in cross validation techinque. It is useful only 
for the case \code{init = 'CV'}.}

\item{search}{a flag to decide the search algorithm type (tree or naive or walking search algorithm).}
}
\value{
If \code{init = 'Heat'} it returns a matrix in which each column contains the initial vector 
for each \code{lambda}. If \code{init = 'CV'} it returns the initial vector associated to the \code{lambda} given.
}
\description{
This function implements two methods for the density initialization procedure.
}
\examples{
library(fdaPDE)

## Create a 2D mesh over a squared domain
Xbound <- seq(-3, 3, length.out = 10)
Ybound <- seq(-3, 3, length.out = 10)
grid_XY <- expand.grid(Xbound, Ybound)
Bounds <- grid_XY[(grid_XY$Var1 \%in\% c(-3, 3)) | (grid_XY$Var2 \%in\% c(-3, 3)), ]
mesh <- create.mesh.2D(nodes = Bounds, order = 1)
mesh <- refine.mesh.2D(mesh, maximum_area = 0.2)
FEMbasis <- create.FEM.basis(mesh)

## Generate data
n <- 50
set.seed(10)
data_x <- rnorm(n)
data_y <- rnorm(n)
data <- cbind(data_x, data_y)

plot(mesh)
points(data, col="red", pch=19, cex=0.5)

## Density initialization
lambda = 0.1
sol = DE.heat.FEM(data, FEMbasis, lambda, heatStep=0.1, heatIter=500, init="Heat")

## Visualization 
plot(FEM(coeff=sol$f_init, FEMbasis=FEMbasis))
}
