% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeLQDsample.R
\name{MakeLQDsample}
\alias{MakeLQDsample}
\title{Convenience function for converting densities to log-quantile densities}
\usage{
MakeLQDsample(dmatrix, dSup, lqdSup = seq(0, 1, length.out = length(dSup)),
  useAlpha = FALSE, alpha = 0.01)
}
\arguments{
\item{dmatrix}{Matrix holding the density values on dSup - all rows must be strictly positive and integrate to 1}

\item{dSup}{Support (grid) for Density domain}

\item{lqdSup}{Support grid for lqd domain (default = seq(0, 1, length.out = length(dSup)))}

\item{useAlpha}{should regularisation be performed (default=FALSE)}

\item{alpha}{Scalar to regularise the supports with (default=0.01)}
}
\value{
list with 'LQD', a matrix of log quantile density functions, and 'lqdSup' that matches the input argument
}
\description{
See 'dens2lqd' and 'RegulariseByAlpha' for more details.
This function first (transforms the densities in 'dmatrix' to log quantile density functions, optionally followed by regularisation.
}
\examples{
 

x <- seq(0,1,length.out = 101)
# some log quantile densities on (0, 1)
y <- t(sapply(seq(0.5, 1.5, length.out = 10), function(b) -log(b^2 + 4*(1-b)*x)/2)) 

# Get densities

y.dens = MakeDENsample(qmatrix = y, lqdSup = x, dSup = x)$DEN
matplot(x, t(y.dens), ylab = 'Density', type = 'l', lty = 1, col = 'black')

# Get LQDs Back

y.lqd = MakeLQDsample(y.dens, lqdSup = x, dSup = x)
# These should match
matplot(y.lqd$lqdSup, t(y.lqd$LQD), ylab = 'LQD', type = 'l', lty = 1, col = 'blue')
matplot(x, t(y), ylab = 'LQD', type = 'l', lty = 1, col = 'red')

}
\references{
\cite{Functional Data Analysis for Density Functions by Transformation to a Hilbert space, Alexander Petersen and Hans-Georg Mueller, 2016}
}
\seealso{
\code{\link{RegulariseByAlpha},\link{dens2lqd}}
}
