% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_karcher_cov.R
\name{curve_karcher_cov}
\alias{curve_karcher_cov}
\title{Curve Karcher Covariance}
\usage{
curve_karcher_cov(betamean, beta, mode = "O")
}
\arguments{
\item{betamean}{array (n,T) of mean curve}

\item{beta}{array (n,T,N) for N number of curves}

\item{mode}{Open ("O") or Closed ("C") curves}
}
\value{
K covariance matrix
}
\description{
Calculate Karcher Covariance of a set of curves
}
\examples{
data("mpeg7")
out = curve_srvf_align(beta[,,1,1:2],maxit=2) # note: use more shapes, small for speed
K = curve_karcher_cov(out$betamean, beta[,,1,1:2])
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}

