% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSummary.R
\name{getSummary}
\alias{getSummary}
\title{Get Summary Data from FDIC API}
\usage{
getSummary(states, range, fields, limit = 10000)
}
\arguments{
\item{states}{a character vector of state names to filter by}

\item{range}{a numeric vector of length two representing the beginning and ending
years to filter by. If NULL, no year filtering will occur.}

\item{fields}{a character vector of field names to include in the output data frame}

\item{limit}{an integer specifying the maximum number of rows to retrieve from the API}
}
\value{
a data frame with summary data for the given states, years, and fields
}
\description{
This function retrieves summary data from the FDIC API based on given state names,
a range of years, and specified fields. The returned data frame includes columns
for state name, year, CB_SI, and the specified fields.
}
\examples{
df <- getSummary(c("West Virginia", "Delaware", "Alabama"), c(2015, 2016), c("ASSET", "INTINC"))
}
