% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_pareto.R
\name{create_pareto}
\alias{create_pareto}
\title{Create Pareto Chart}
\usage{
create_pareto(df, title = "Pareto Chart", subtitle = "",
  caption = "", x_label = "Groups", y_label = "Frequency")
}
\arguments{
\item{df}{Data frame containing a frequency distribution table.}

\item{title}{Character string; title to be displayed on Pareto chart.  Default
is "Pareto Chart".}

\item{subtitle}{Character string; subtitle to be displayed on chart.  Default
is "".}

\item{caption}{Character string; caption to be displayed on the chart.  Default
is "".}

\item{x_label}{Character string; x axis label to be displayed on the chart.
Default is "Groups".}

\item{y_label}{Character string; y axis label to be displayed on the chart.
Default is "Frequency".}
}
\value{
A plot containing a Pareto chart.  If an error or warning occurs,
a message will be printed to the console and the function will return NULL.
}
\description{
\code{create_pareto} generates a Pareto chart using the group, frequency and
cumulative frequency columns of a frequency distribution table.
}
\examples{
source <- c(1, 1, 1, 1, 2, 2, 2, 3, 3, 4)
table <- create_table(source, dec_pos = 3)
plot <- create_pareto(table)

}
