% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{evaluate}
\alias{evaluate}
\title{Evaluate several classication (or regression) methods}
\usage{
evaluate(methods, dataset, target = NULL, size = round(0.7 *
  nrow(dataset)), names = NULL, eval = "accuracy", seed = NULL, ...)
}
\arguments{
\item{methods}{The classification or regression method to be evaluated.}

\item{dataset}{The dataset to be split (\code{data.frame} or \code{matrix}).}

\item{target}{The column index of the target variable (class label or response variable).}

\item{size}{The size of the training set (as an integer value).}

\item{names}{Method names.}

\item{eval}{The evaluation function.}

\item{seed}{A specified seed for random number generation.}

\item{...}{Other specific parameters for the leaning method.}
}
\value{
The evaluation of the predictions (numeric value).
}
\description{
Evaluation a classification or regression method using bootstrap approach.
}
\examples{
require ("datasets")
data (iris)
evaluate (c (NB, LDA), iris, target = 5, eval = c ("accuracy", "kappa"), seed = 0)
}
\seealso{
\code{\link{bootstrap}}, \code{\link{evaluation}}, \code{\link{splitdata}}
}
