% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/febr.R
\name{febr}
\alias{febr}
\title{Get all dataset tables}
\usage{
febr(dataset, merge = FALSE, progress = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{dataset}{Character vector indicating one or more datasets. Identification codes should be as recorded
in \url{http://www.ufsm.br/febr/catalog/}. Use \code{dataset = "all"} to download all datasets.}

\item{merge}{(optional) Logical value indicating if the \emph{observation} ("observacao") and \emph{layer} ("camada")
tables should be merged. Defaults to \code{merge = FALSE}. See \code{\link[base]{merge}} for more details.}

\item{progress}{(optional) Logical value indicating if a download progress bar should be displayed.}

\item{verbose}{(optional) Logical value indicating if informative messages should be displayed. Generally
useful to identify datasets with inconsistent data. Please report to \email{febr-forum@googlegroups.com}
if you find any issue.}

\item{...}{(optional) Arguments passed to \code{\link[febr]{observation}} and \code{\link[febr]{layer}}.}
}
\value{
A list of data frames with data on the chosen dataset.
}
\description{
Download data from the \emph{dataset} ("dataset"), \emph{observation} ("observacao"), \emph{layer} ("camada"), and
\emph{metadata} ("metadado") tables of a dataset contained in the Free Brazilian Repository for Open Soil Data
-- \emph{\strong{febr}}, \url{http://www.ufsm.br/febr}.
}
\details{
Character vector indicating one dataset. The identification code should be as recorded in
\url{http://www.ufsm.br/febr/catalog/}.
}
\examples{
\donttest{ 
# res <- febr(dataset = "ctb0013")
}
}
\seealso{
\code{\link[febr]{dataset}}, \code{\link[febr]{observation}}, \code{\link[febr]{layer}},
\code{\link[febr]{metadata}}
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
