% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedstat_check_data_update.R
\name{fedstat_check_data_update}
\alias{fedstat_check_data_update}
\title{Very basic task scheduler for checking the indicator data updates (EXPERIMENTAL)}
\usage{
fedstat_check_data_update(
  prepared_reference_data_for_check_data_update,
  ...,
  pause_minutes_between_requests = 30,
  max_checks = 50,
  verbose_tries = TRUE,
  timeout_seconds = 180,
  retry_max_times = 10,
  disable_warnings = TRUE,
  httr_verbose = NULL,
  logfile = NULL,
  overwrite_logfile = FALSE
)
}
\arguments{
\item{prepared_reference_data_for_check_data_update}{result of
\link{fedstat_prepare_reference_data_for_check_data_update}}

\item{...}{other arguments passed to httr::GET and httr::POST}

\item{pause_minutes_between_requests}{numeric, the number of minutes to wait
before the next request, cannot be less than 10 minutes to avoid a heavy load on the fedstat.ru
The time between requests will not be exactly equal to the specified value,
because the countdown starts only after the request is finished}

\item{max_checks}{numeric, maximum number of checks before returning \code{FALSE}}

\item{verbose_tries}{bool, enables or disables verbose messages,
sends messages to the console about the progress of attempts to find out whether the data have been updated}

\item{timeout_seconds}{numeric, maximum time before a new GET and POST request is tried}

\item{retry_max_times}{numeric, maximum number of tries to GET and POST \code{data_ids}}

\item{disable_warnings}{bool, enables or disables following warnings in \code{fedstat_data_ids_filter}:
\enumerate{
\item About non matched \code{filter_value_title} in \code{filters} and \code{filter_value_title} from \code{data_ids};
\item About unspecified \code{filter_filed_title} in \code{filters}.
}}

\item{httr_verbose}{\code{httr::verbose()} or NULL, outputs messages to the console
about the processing of the request}

\item{logfile}{the path to the log file, if NULL, the messages are sent to the console}

\item{overwrite_logfile}{boolean, if true overwrites content of \code{logfile}}
}
\value{
bool, TRUE if indicator data has been updated, FALSE if max_checks is exceeded
}
\description{
In practice fedstat often does not give true
information about when the data was updated. Because of this,
the only universal and accurate way to check for updated data is to try to
download it and compare it to past data. If a query with the same filters
as before returned different \code{data_ids} or \code{data_df}
(result of \code{fedstat_parse_sdmx_to_table}), then the data has been updated.

This function is not tested on real data

Logging to a file is supported
}
\examples{
\dontrun{
is_updated <- fedstat_prepare_reference_data_for_check_data_update(
  indicator_id = "37426",
  filters = list(
    "Territory" = "Russian Federation",
    "Types of goods and services" = "Sahar-pesok, kg"
  )
) \%>\%
  fedstat_check_data_update(logfile = "logfile.txt")

if (is_updated) print("Data for the indicator 37426 has been updated!")

# Not actual filter field titles and filter values titles because of ASCII requirement for CRAN
}
}
