% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedstat_data_load_with_filters.R
\name{fedstat_data_load_with_filters}
\alias{fedstat_data_load_with_filters}
\title{Download subset of indicator data from fedstat.ru by specifying filters in JSON}
\usage{
fedstat_data_load_with_filters(
  indicator_id,
  ...,
  filters = list(),
  filter_value_title_alias_lookup_table = data.frame(filter_value_title = character(),
    filter_value_title_alias = character(), stringsAsFactors = FALSE),
  timeout_seconds = 180,
  retry_max_times = 3,
  disable_warnings = FALSE,
  httr_verbose = httr::verbose(data_out = FALSE)
)
}
\arguments{
\item{indicator_id}{character, indicator id/code from indicator URL.
For example for indicator with URL https://www.fedstat.ru/indicator/37426 indicator id will be 37426}

\item{...}{other arguments passed to httr::GET and httr::POST}

\item{filters}{JSON in R list form. The structure should be like this:

\preformatted{
{
 "filter_field_title1": ["filter_value_title1", "filter_value_title2"],
 "filter_field_title2": ["filter_value_title1", "filter_value_title2"],
 ...
}
}

Where for example \code{filter_field_title1} could be a string "Year" with
\code{filter_value_title1} equal to 2020 and \code{filter_field_title2}
could be a string "OKATO" with \code{filter_value_title1}
equal to "Russian Federation"
Not actual filter field titles and filter values titles
because of ASCII requirement for CRAN}

\item{filter_value_title_alias_lookup_table}{data.frame with columns \code{filter_value_title} and \code{filter_value_title_alias}.
Used to replace \code{filter_value_title} with standard forms of filter value titles.
It is mainly used to set consistent names.
For example, the Dalnevostochnyj federalnyj okrug ( s 03.11.2018) (transliteration for CRAN) in \code{filter_value_title}
can be simply replaced with \code{filter_value_title_alias} as Dalnevostochnyj federalnyj okrug.
In this example in fact, these are two different entities (after the inclusion of Buryatia and Transbaikalia and before),
but in most cases such a replacement is more convenient for loading data, since you need the whole time series.
By default it's empty data.frame, e.g. no replacement for anything.}

\item{timeout_seconds}{numeric, maximum time before a new GET and POST request is tried}

\item{retry_max_times}{numeric, maximum number of tries to GET and POST \code{data_ids}}

\item{disable_warnings}{bool, enables or disables following warnings:
\enumerate{
\item About non matched \code{filter_value_title} in \code{filters} and \code{filter_value_title} from \code{data_ids};
\item About unspecified \code{filter_filed_title} in filters.
}}

\item{httr_verbose}{\code{httr::verbose()} or NULL, outputs messages to the console
about the processing of the request}
}
\value{
data.frame with filtered indicator data from fedstat.ru
}
\description{
This function is a wrapper for the other functions of the package
to provide a simple one function API for fedstat.ru

There are two basic terms in this API: \code{filter_field} and \code{filter_value}

The \verb{filter field} reflects the individual property of the data point.
For example, Year, Region, Unit of measurement, etc.
Each filter field has its own title (\code{filter_field_title}),
it is simply a human-readable word or phrase (e.g. "Year", "Region")
that reflects the essence of the property by which filtering takes place

The \verb{filter field} reflects the individual property specific value of the data point.
(e.g. 2021 for Year, "Russian Federation" for Region, etc.)
It also has a title (\code{filter_value_title}) with
the same purpose as \code{filter_field_title}

\code{filters} should use \code{filter_field_title} in names and \code{filter_value_title} in values as
they are presented on fedstat.ru. If for some reason the specified filters
do not return the expected result, it is worth using
\code{\link{fedstat_get_data_ids}} separately and inspecting possible
filter values in \code{data_ids} to see if the strings are defined correctly
(e.g. encoding issues, mixing latin and cyrillic symbols)

\code{filter_value_title} currently supports the following special values:
\enumerate{
\item asterix (*), alias for "select all possible filter values for this filter field"
}

Unspecified filters use asterix as a default
(i.e. all possible filter values are selected and a warning is given)

Internally normalized \code{filter_field_title} and \code{filter_value_title} are
used (all lowercase, removed extra whitespaces)
to compare the equality of \code{data_ids} and \code{filters}
}
\examples{
\dontrun{
# Download weekly goods and services prices data for week 21 and 22 of 2021
# for all goods and services for Russian Federation
data <- fedstat_data_load_with_filters(
  indicator_id = "37426",
  filters = list(
    "Territory" = "Russian Federation",
    "Year" = "2021",
    "Period" = c(21, 22),
    "Types of goods and services" = "*"
  )
)
# Not actual filter field titles and filter values titles because of ASCII requirement for CRAN
}
}
\seealso{
\code{
  \link{fedstat_get_data_ids},
  \link{fedstat_get_data_ids_special_cases_handle},
  \link{fedstat_data_ids_filter},
  \link{fedstat_post_data_ids_filtered},
  \link{fedstat_parse_sdmx_to_table}
  }
}
