% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda-pettitt-test.R
\name{eda_pettitt_test}
\alias{eda_pettitt_test}
\title{Pettitt Test for Abrupt Changes in the Mean of a Time Series}
\usage{
eda_pettitt_test(data, years, alpha = 0.05)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{years}{Numeric vector of observation years corresponding to \code{data}.
Must be the same length as \code{data} and strictly increasing.}

\item{alpha}{Numeric scalar in \eqn{[0.01, 0.1]}. The significance
level for confidence intervals or hypothesis tests. Default is 0.05.}
}
\value{
A list containing the test results, including:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{years}: The \code{years} argument.
\item \code{alpha}: The significance level as specified in the \code{alpha} argument.
\item \code{null_hypothesis}: A string describing the null hypothesis.
\item \code{alternative_hypothesis}: A string describing the alternative hypothesis.
\item \code{u_series}: Numeric vector of absolute U-statistics for all years.
\item \code{statistic}: The test statistic and maximum absolute U-statistic.
\item \code{bound}: The critical value of the test statistic based on \code{alpha}.
\item \code{change_points}: A dataframe containing the potential change point.
\item \code{p_value}: An asymptotic approximation of the  p-value for the test.
\item \code{reject}: Logical scalar. If \code{TRUE}, the null hypothesis was rejected.
}

\code{change_points} contains the years, test statistics, and p-values of each
potential change point. If no change points were identified, \code{change_points}
is empty.
}
\description{
Performs the nonparametric Pettitt test to detect a single abrupt change in the
central tendency of a time series. Under the null hypothesis, there is no change.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
years <- seq(from = 1901, to = 2000)
eda_pettitt_test(data, years)

}
\references{
Pettitt, A.N., 1979. A Non-parametric Approach to the Change-point Problem. J.
Royal Statistics Society 28 (2), 126–135. \url{http://www.jstor.org/stable/2346729}
}
\seealso{
\code{\link[=plot_pettitt_test]{plot_pettitt_test()}}, \code{\link[=eda_mks_test]{eda_mks_test()}}
}
