% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/league-settings.R
\name{fee_settings}
\alias{fee_settings}
\title{League finance settings}
\usage{
fee_settings(lid = getOption("lid"), old = FALSE, ...)
}
\arguments{
\item{lid}{ESPN League ID, defaults to \code{getOption("lid")}. Use
\verb{options(lid = <League ID>)} to set your league ID; put that line in your
\code{.Rprofile} file to set the option at start up.}

\item{old}{If \code{FALSE} (default), return only the current season's data. If
\code{TRUE}, return a list with all prior seasons.}

\item{...}{Additional API query arguments. Use "week" and "year" as a
shorthand for "ScoringPeriodId" and "seasonId" respectively.}
}
\value{
A list or tibble of finance settings.
}
\description{
The off-site fees assigned to various roster movies and transactions.
}
\examples{
fee_settings(252353, old = TRUE)
}
