% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/views.R
\name{bind_views}
\alias{bind_views}
\title{Stack Different Views}
\usage{
bind_views(...)
}
\arguments{
\item{...}{Objects of the class \code{ffp_views} to combine.}
}
\value{
A \code{list} of the \code{view} class.
}
\description{
Bind views for entropy programming.
}
\examples{
library(ggplot2)

# Invariant
ret <- diff(log(EuStockMarkets))
n   <- nrow(ret)

# Prior probabilities (usually equal weight scheme)
prior <- rep(1 / n, n)

# Prior belief for expected returns (here is 0\% for each asset)
view_mean <- view_on_mean(x = ret, mean = rep(0, 4))

#' view on volatility
vol <- apply(ret, 2, stats::sd) * 1.1 # volatility 10\% higher than average
view_volatility <- view_on_volatility(x = ret, vol = vol)

views_comb <- bind_views(view_mean, view_volatility)
views_comb

ep <- entropy_pooling(p      = prior,
                      Aeq    = views_comb$Aeq,
                      beq    = views_comb$beq,
                      A      = views_comb$A,
                      b      = views_comb$b,
                      solver = "nlminb")
autoplot(ep)
}
