% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/espn_rosters.R,
%   R/flea_rosters.R, R/mfl_rosters.R, R/sleeper_rosters.R
\name{ff_rosters}
\alias{ff_rosters}
\alias{ff_rosters.espn_conn}
\alias{ff_rosters.flea_conn}
\alias{ff_rosters.mfl_conn}
\alias{ff_rosters.sleeper_conn}
\title{Get League Rosters}
\usage{
ff_rosters(conn, ...)

\method{ff_rosters}{espn_conn}(conn, ...)

\method{ff_rosters}{flea_conn}(conn, ...)

\method{ff_rosters}{mfl_conn}(conn, custom_players = deprecated(), week = NULL, ...)

\method{ff_rosters}{sleeper_conn}(conn, ...)
}
\arguments{
\item{conn}{a conn object created by \code{ff_connect()}}

\item{...}{arguments passed to other methods (currently none)}

\item{custom_players}{`r lifecycle::badge("deprecated")` - now returns custom players by default}

\item{week}{a numeric that specifies which week to return}
}
\value{
A tidy dataframe of rosters, joined to basic player information and basic franchise information
}
\description{
This function returns a tidy dataframe of team rosters
}
\section{Methods (by class)}{
\itemize{
\item \code{espn_conn}: ESPN: Returns all roster data.

\item \code{flea_conn}: Fleaflicker: Returns roster data (minus age as of right now)

\item \code{mfl_conn}: MFL: returns roster data

\item \code{sleeper_conn}: Sleeper: Returns all roster data.
}}

\examples{
\donttest{
conn <- espn_connect(season = 2020, league_id = 899513)
ff_league(conn)
}
\donttest{
joe_conn <- ff_connect(platform = "fleaflicker", league_id = 312861, season = 2020)
ff_rosters(joe_conn)
}
\donttest{
ssb_conn <- ff_connect(platform = "mfl", league_id = 54040, season = 2020)
ff_rosters(ssb_conn)
}

\donttest{
jml_conn <- ff_connect(platform = "sleeper", league_id = "522458773317046272", season = 2020)
ff_rosters(jml_conn)
}
}
