% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espn_connect.R
\name{espn_connect}
\alias{espn_connect}
\title{Connect to ESPN League}
\usage{
espn_connect(
  season = NULL,
  league_id = NULL,
  swid = NULL,
  espn_s2 = NULL,
  user_agent = NULL,
  rate_limit = TRUE,
  rate_limit_number = NULL,
  rate_limit_seconds = NULL,
  ...
)
}
\arguments{
\item{season}{Season to access on Fleaflicker - if missing, will guess based on system date (current year if March or later, otherwise previous year)}

\item{league_id}{League ID}

\item{swid}{SWID parameter for accessing private leagues - see vignette for details}

\item{espn_s2}{ESPN_S2 parameter for accessing private leagues - see vignette for details}

\item{user_agent}{User agent to self-identify (optional)}

\item{rate_limit}{TRUE by default - turn off rate limiting with FALSE}

\item{rate_limit_number}{number of calls per \code{rate_limit_seconds}, suggested is under 1000 calls per 60 seconds}

\item{rate_limit_seconds}{number of seconds as denominator for rate_limit}

\item{...}{other arguments (for other methods, for R compat)}
}
\value{
a list that stores ESPN connection objects
}
\description{
This function creates a connection object which stores parameters and a user ID if available.
}
\examples{
\donttest{
conn <- espn_connect(
  season = 2018,
  league_id = 1178049,
  espn_s2 = Sys.getenv("TAN_ESPN_S2"),
  swid = Sys.getenv("TAN_SWID")
)
}

}
