#### UTILS ###
# External functions imported and sometimes re-exported

# data.table is generally careful to minimize the scope for namespace
# conflicts (i.e., functions with the same name as in other packages);
# a more conservative approach using @importFrom should be careful to
# import any needed data.table special symbols as well, e.g., if you
# run DT[ , .N, by='grp'] in your package, you'll need to add
# @importFrom data.table .N to prevent the NOTE from R CMD check.
# See ?data.table::`special-symbols` for the list of such symbols
# data.table defines; see the 'Importing data.table' vignette for more
# advice (vignette('datatable-importing', 'data.table')).
#
#' @importFrom data.table .N .SD `:=`
#' @keywords internal
NULL

globalVariables(".")
.datatable.aware <- TRUE

#' @keywords internal
#' @importFrom rlang .data `%||%` .env
#' @importFrom utils str
#' @importFrom stats median
NULL

#' Pipe operator
#'
#' See \code{magrittr::\link[magrittr:pipe]{\%>\%}} for details.
#'
#' @name %>%
#' @rdname pipe
#' @keywords internal
#' @export
#' @importFrom magrittr %>%
#' @usage lhs \%>\% rhs
#' @param lhs A value or the magrittr placeholder.
#' @param rhs A function call using the magrittr semantics.
#' @return The result of calling `rhs(lhs)`.
NULL

#' @keywords internal
"_PACKAGE"

# The following block is used by usethis to automatically manage
# roxygen namespace tags. Modify with care!
## usethis namespace: start
## usethis namespace: end
NULL

#' Access cached function data
#'
#' @noRd
#' @export
.ffs_cache <- function(filename) {
    readRDS(
      system.file(
        file.path("cache", filename),
        package = "ffsimulator")
    )
}

set_verbose <- function(verbose = NULL) {

  if(isTRUE(verbose)) options(ffsimulator.verbose = TRUE)
  if(!isTRUE(verbose)) options(ffsimulator.verbose = FALSE)

  return(NULL)
}

vcli_start <- function(...){
  v <- getOption("ffsimulator.verbose", default = TRUE)

  if(!v) return(NULL)

  cli::cli_process_start(...)
}

vcli_end <- function(...){
  v <- getOption("ffsimulator.verbose", default = TRUE)

  if(!v) return(NULL)

  cli::cli_process_done(...)
}

vcli_rule <- function(...){
  v <- getOption("ffsimulator.verbose", default = TRUE)

  if(!v) return(NULL)

  cli::cli_rule(...)
}
