% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_detectCUSUMMeanSingle}
\alias{cpp_detectCUSUMMeanSingle}
\title{Find the first changepoint in the mean using CUSUM}
\usage{
cpp_detectCUSUMMeanSingle(x, k, h, BL)
}
\arguments{
\item{x}{Vector of numeric values values.}

\item{k}{control parameter for CUSUM}

\item{h}{control parameter for CUSUM}

\item{BL}{Value for the burn-in length.}
}
\value{
A list with 
\describe{
            \item{\code{tauhat}}{A vector of the changepoints found.}
         }
}
\description{
Given a vector \code{x}, control parameters \code{k} and \code{h},
and a burn-in length \code{BL}, returns a list containing the changepoints.
Algorithm is implemented in C++.
}
\details{
CUSUM updates via: 
         \deqn{S_{j} = \max{0, S_{j-1} + (x_{j} - \mu)/ \sigma - k}}
         where \eqn{\mu} and \eqn{\sigma} are, respectively, the mean 
         and variance of the in-control stream, 
         \eqn{x_j} is the observation at time \eqn{j}
         and \eqn{k} 
         is a control parameter for CUSUM. Then, a change is signalled
         if \eqn{S_j > h}, where \eqn{h} is the other control parameter.
         This is the formulation for using CUSUM to detect an increase
         in the mean; there is a similar formulation for detecting a 
         decrease, and usually CUSUM is two-sided (monitors for an 
         increase and a decrease in the mean).
}
\keyword{internal}
