% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.r
\name{table.plot}
\alias{table.plot}
\title{table.plot}
\usage{
table.plot(
  parent.df,
  y.rank.col = "Subcategory",
  category.color = "Treatment",
  text.col1 = "Point_Est",
  text.col2 = NULL,
  text.col3 = NULL,
  text.col4 = NULL,
  text.size = 12,
  xtick.labs = c("", "", ""),
  x.limits = NULL,
  y.limits = NULL,
  x.label = "Text",
  y.label = "Item",
  y.label.rank.col = "rank",
  y.label.col = "subcategory",
  category.palette = c("red", "blue")
)
}
\arguments{
\item{parent.df}{data.frame used by ggplot}

\item{y.rank.col}{column holding ranks for line items in forest/dot/table plots}

\item{category.color}{data.frame column assocated with aes color mapping (forest.plot, line.plot, nsubj.plot, table.plot)}

\item{text.col1}{name of column holding text for column 1 (table.plot)}

\item{text.col2}{name of column holding text for column 2; can be NULL (table.plot)}

\item{text.col3}{name of column holding text for column 3; can be NULL (table.plot)}

\item{text.col4}{name of column holding text for column 4; can be NULL (table.plot)}

\item{text.size}{value gets passed to geom_text}

\item{xtick.labs}{xtick labels}

\item{x.limits}{value gets passed to scale_x_continuous}

\item{y.limits}{passed to scale_y_continuous}

\item{x.label}{value gets passed to labs}

\item{y.label}{value gets passed to labs}

\item{y.label.rank.col}{column holding ranks for labels in forest/dot/table plots}

\item{y.label.col}{column holding labels for forest/dot/table plots}

\item{category.palette}{colors assoicated with categorical variable}
}
\value{
A ggplot object is returned.
}
\description{
A function for creating harmonized table plots with 
A function for plotting columns of text in a figure offering compatiability with forest.plot and dot.plot.
}
\author{
Greg Cicconetti
}
