% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{count_matches}
\alias{count_matches}
\title{Count the number of the matches of a pattern in a string.}
\usage{
count_matches(string, pattern)
}
\arguments{
\item{string}{A character vector.}

\item{pattern}{A character vector. Pattern(s) specified like the pattern(s)
in the stringr package (e.g. look at \code{\link[stringr:str_locate]{stringr::str_locate()}}). If
this has length >1 its length must be the same as that of \code{string}.}
}
\value{
A numeric vector giving the number of matches in each string.
}
\description{
Vectorised over \code{string} and pattern.
}
\examples{
count_matches("abacad", "a")
count_matches("2.1.0.13", ".")
count_matches("2.1.0.13", stringr::coll("."))
}
