% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{singleize}
\alias{singleize}
\title{Remove back-to-back duplicates of a pattern in a string.}
\usage{
singleize(string, pattern)
}
\arguments{
\item{string}{A character vector. The string(s) to be purged of duplicates.}

\item{pattern}{A character vector. Tegular expression(s) of the pattern(s)
that we wish not to be duplicated.}
}
\value{
The string with the duplicates fixed.
}
\description{
If a string contains a given pattern duplicated back-to-back a number of
times, remove that duplication, leaving the pattern appearing once in that
position (works if the pattern is duplicated in different parts of a string,
removing all instances of duplication). This is vectorised over string and
pattern.
}
\examples{
singleize("abc//def", "/")
singleize("abababcabab", "ab")
singleize(c("abab", "cdcd"), "cd")
singleize(c("abab", "cdcd"), c("ab", "cd"))
}
