% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{cft_fish}
\alias{cft_fish}
\title{Example fish data from CalFishTrack}
\format{
\subsection{\code{cft_fish}}{

A dataframe with 17,227 rows and 25 columns
\describe{
\item{fish_id}{Identifies the fish that was tagged. It is unique in that no
two fish have the same FishID. Format is 2 or more letters that describe
the type of the fish (e.g. WR for WinterRun), followed by the year (YYYY),
followed by a dash, then a sequential three digit number (e.g. 001 to 999)}
\item{study_id}{Identifies a group of tagged fish that belong to a study.
Format is text description of place followed by year (YYYY). A single
StudyID can have fish release on multiple days within a year and/or at
multiple locations within a year.}
\item{fish_type}{Describes the fish tagged. Generally a part that describes
where it came from and a part that refers to the common name.}
\item{fish_origin}{Describes where the fish is from or where it was
collected. Example: Hatchery, Natural, Sacramento River.}
\item{fish_date_tagged}{The date and time that indicates the time the tag
was activated and implanted into the fish. Tags are usually activated
several minutes before implanting into fish in PST.}
\item{fish_release_date}{The date and time of release in PST.}
\item{tag_id_hex}{The hexadecimal form for the tags code. This is not
unique in that two fish can have the same Hex Tag Code. This is usually
from the same tag code being used in different years. This is why all
queries must be based on Fish ID.}
\item{tag_id_decimal}{The decimal form for the tags code. This is not
unique in that two fish can have the same Decimal Tag Code. This is
usually from the same tag code being used in different years. This is why
all queries must be based on Fish ID.}
\item{tag_weight}{weight of tag in air}
\item{tag_model}{The model of the tag.}
\item{tag_pulse_rate_interval_nominal}{The nominal (aka approximate) pulse
rate interval. This is how often the tag transmits its code signal.}
\item{tag_warranty_life}{The minimum number of days a tag is expected to
transmit its code. Generally tags transmit for at least 1.5x the warranty
life.}
\item{fish_length_type}{The way the fish was measured. Fork length = FL,
total length = TL, standard length = SL. If unknown = NA.}
\item{fish_length}{Measured fish length in millimeters}
\item{fish_weight}{Measured fish weight in grams (in air)}
\item{release_location}{The name of the place that the fish was released.}
\item{release_latitude}{The latitude of the release location.}
\item{release_longitude}{The longitude of the release location.}
\item{release_river_km}{The river km of the release location.
The Golden Gate Bridge = rkm 0.0. Values increase the further upstream.}
\item{email}{the email address of the point of contact that grants approval
for using the data from each fish.}
}
}
}
\usage{
cft_fish
}
\description{
A dataframe of acoustically tagged fish downloaded from ERDDAP representing
fish released in 2021 and 2022.
}
\keyword{datasets}
