% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalfit_internal_functions.R
\name{colname2label}
\alias{colname2label}
\title{Change column names to variable labels}
\usage{
colname2label(.data, .cols)
}
\arguments{
\item{.data}{Data frame}

\item{.cols}{Quoted character vector of columns to change}
}
\description{
Written to support stratified tables to \code{\link{summary_factorlist}}. See
example below for explantion.
}
\examples{
library(rlang)
library(dplyr)
explanatory = c("age.factor", "sex.factor")
dependent = "perfor.factor"

# Pick option below
split = "rx.factor"
split = c("rx.factor", "node4.factor")

# Piped function to generate stratified crosstabs table
colon_s \%>\%
  group_by(!!! syms(split)) \%>\% #Looks awkward, but avoids unquoted var names
  do(
    summary_factorlist(., dependent, explanatory, total = TRUE, p = TRUE)
  ) \%>\%
  data.frame() \%>\%
  dependent_label(colon_s, dependent, prefix = "") \%>\%
  colname2label(split)
  
}
