% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filters}
\alias{filters}
\title{Filtering FinBIF records}
\description{
Filters available for FinBIF records and occurrence data.
}
\section{Taxa}{

Filters related to taxa include:
\itemize{
\item \code{taxon_id} Character vector.
FinBIF taxon IDs. The functions \code{\link[=finbif_check_taxa]{finbif_check_taxa()}} and \code{\link[=finbif_taxa]{finbif_taxa()}}
can be used to search for taxon IDs.
\item \code{taxon_name} Character vector.
Filter based on taxon names (scientific or common) rather than IDs. If the
specified taxa are not found in the FinBIF taxonomy then matches are
attempted with the occurrence record names as originally supplied verbatim.
\item \code{quality_controlled_det} Logical.
If \code{TRUE} (default) use quality controlled taxonomic determinations. Or, if
\code{FALSE} use the originally recorded taxonomic determinations.
\item \code{subtaxa} Logical.
If \code{TRUE} (default) return records of all taxa belonging to specified taxa.
Or, if \code{FALSE} only return records for exact matches to the specified taxa
(e.g., if a genus is specified, do not return records of the species
belonging to the genus, return records of individuals identified as that
genus only and not identified to a lower taxonomic level).
\item \code{invalid_taxa} Logical.
If \code{TRUE} (default) return records for taxa not found in the FinBIF
taxonomic database as well as taxa that are in the FinBIF database. Or, if
\code{FALSE} limit records to only those of taxa found in the FinBIF database.
\item \code{informal_groups} Character vector.
Filter by informal taxonomic groups. Only including informal groups linked
to the recorded taxa in the FinBIF database. Use the function
\code{\link[=finbif_informal_groups]{finbif_informal_groups()}} to see the informal taxonomic groups available
in FinBIF.
\item \code{informal_groups_reported} Character vector.
Filter by informal taxonomic groups including groups reported directly with
the record and those linked to the recorded taxa in the FinBIF database.
Use the function \code{\link[=finbif_informal_groups]{finbif_informal_groups()}} to see the informal taxonomic
groups available in FinBIF.
\item \code{regulatory_status} Character vector.
Filter by regulatory status code. Use the function
\code{\link[=finbif_metadata]{finbif_metadata()}} to see regulatory statuses and codes.
\item \code{red_list_status} Character vector.
Filter by IUCN red list status code. Use the function \code{\link[=finbif_metadata]{finbif_metadata()}}
to see red list statuses and codes.
\item \code{primary_habitat} Character vector or named list of character vectors.
Filter by primary habitat code. Use the function \code{\link[=finbif_metadata]{finbif_metadata()}}
to see habitat (sub)types and codes for taxa in the FinBIF database.
Habitat type/subtypes can be refined further by indicating habitat
qualifiers with a named list of character vectors where the names are
habitat (sub)type codes and the elements of the character vector are the
habitat qualifier codes. Use the function \code{\link[=finbif_metadata]{finbif_metadata()}} to
see habitat qualifiers and codes. The records returned will be of taxa
whose primary habitat is considered to be the (sub)habitat/habitat
qualifier combination supplied.
\item \code{primary_secondary_habitat} Character or named list of character vectors.
As above, except the records returned will be of taxa whose primary or
secondary habitat is considered to be the combination supplied.
\item \code{finnish_occurrence_status} Character vector.
Filter by Finnish occurrence status of taxa. Use
\code{\link[=finbif_metadata]{finbif_metadata()}} to see the possible occurrence
statuses of taxa.
\item \code{finnish_occurrence_status_neg} Character vector.
Negation of the above. Selecting a status will filter out rather than
include records with the selected status.
\item \code{finnish} Logical.
If \code{TRUE}, limit records to taxa thought to occur in Finland. Or if \code{FALSE}
limit to taxa not thought to occur in Finland. If unspecified (default)
return records of all taxa.
\item \code{invasive} Logical.
If \code{TRUE}, limit records to invasive taxa. Or if \code{FALSE} limit to
non-invasive taxa. If unspecified (default) return records of invasive and
non-invasive taxa.
\item \code{taxon_rank} Character vector.
Filter by taxonomic rank. Use \code{finbif_metadata()} to see the taxonomic
ranks available. Records returned will be limited to the specified ranks
and not include records of lower taxonomic levels.
}
}

\section{Location}{

Filters related to location of record include:
\itemize{
\item \code{locality} Character vector.
Filter by name of locality. Will first try to match strings to the
countries, bio-provinces, and municipalities (see below) in FinBIF, if none
of these locality types match exactly then will return records with
verbatim locality matches in the original records.
\item \code{country} Character vector.
Filter by country. Use \code{finbif_metadata()} to see country names and ISO
codes (2 and 3 character) used in FinBIF.
\item \code{region} Character vector.
Filter by region. Use \code{finbif_metadata()} to see region names and codes.
\item \code{bio_province} Character vector.
Filter by bio-province. Use \code{finbif_metadata()} to see bio-province names
and codes.
\item \code{municipality} Character vector.
Filter by municipality. Use \code{finbif_metadata()} to see municipality
names.
\item \code{location_tag} Character vector
Filter by tags associated with a location (e.g., \code{"farmland"}).
\item \code{bird_assoc_area} Character vector.
Filter by BirdLife Finland association area. Use \code{finbif_metadata()}
to see association names and codes.
\item \code{coordinates} Coordinates.
A character vector or list of coordinate data. Must be length 3 to 4 (e.g.,
\code{list(lat = c(60.4, 61), lon = c(22, 22.5), system = "wgs84", ratio = 1)}.
The first element is minimum and maximum latitude and the second minimum
and maximum longitude (or can be minimums only). The third element is the
coordinate system; either one of \code{"wgs84"}, \code{"euref"} or \code{"ykj"}. The
optional fourth element is a positive value less than \code{1}. When \code{1}, the
coverage area of the returned records will be completely within the box
bound by the coordinates values. Values less than \code{1} requires the returned
record's coverage to overlap with the bounding box in that proportion. When
using the system "\code{ykj}" the coordinates will be coerced to integers with
units inferred from the number of integer digits (7 digits equals km's, 6
equals 10km's, etc.,). If coordinate maximums are not specified they will
be assumed to be one unit above the minimums (e.g., \code{c(666, 333, "ykj")} is
equivalent to \code{list(c(6660000, 6670000), c(3330000, 3340000), "ykj")}).
\item \code{coordinates_center} Coordinates.
A character vector or list of coordinate data. Must be of length 3. The
first two elements are latitude and longitude and third is the coordinate
system (currently only \code{"wgs84"} is implemented). Records returned will be
those for which the center point exactly matches that which is specified.
\item \verb{coordinates_cell_\{1k|10k|50k|100k\}} Coordinates.
A vector of coordinate data (lat, lon). Filter by grid cell at scale \code{*}.
Where \code{*} is 1, 10, 50 or 100. The coordinates specify the southeast corner
of the cell. Coordinates system is \code{"ykj"}.
\item \verb{coordinates_cell_\{1k|10k|50k|100k\}_center} Coordinates.
As above, except coordinates indicate center of grid cell.
\item \code{coordinates_source} Character.
Filter by source of coordinates. Currently accepted values are
\code{"reported_value"} (coordinates were recorded at time of observation) and
\code{"finnish_municipality"} (coordinates were derived and observer only
recorded municipality).
\item \code{coordinates_uncertainty_max} Integer.
Filter by maximum uncertainty of coordinates (i.e.,
\code{coordinates_uncertainty_max = 100} will return records that are accurate
to 100m).
}
}

\section{Time}{

Filters related to time of record include:
\itemize{
\item \code{date_range_ymd} Dates.
An \link[lubridate:Interval-class]{Interval} object or a vector of one to
two \link[base:Dates]{Date} objects (begin and end dates) or objects that
are coercible to the \link[base:Dates]{Date} class by
\link[lubridate]{as_date}. When supplying dates as strings, the day or
month-and-day can be omitted (e.g.,\code{"2001-04"} or \code{"2001"}). Note however,
that when omitting day, only "\code{-}" is allowed to separate year and month,
and months must be in two-digit/leading zero form. If the begin or end
dates are partial date strings they will be interpreted as the first or
last day of the month or year (e.g., \code{c(2001, 2003)} is equivalent to
\code{c("2001-01-01", "2003-12-12")}). If a single date is supplied as a partial
date string then all records that fall within that month or year will be
returned (e.g., \code{c("2001-01")} is equivalent to
\code{c("2001-01-01", "2001-01-31")}). Use empty strings for the begin or end
date to specify open-ended date ranges (e.g., \code{c("2000-01-01", "")} for
all dates from the turn of the century).
\item \code{date_range_ym} Dates.
As above, but days (if supplied) will be ignored.
\item \code{date_range_d} Integer vector.
Filter by day of the year (e.g., \code{1} to \code{366}). If begin or end date is
omitted then it is interpreted as the first or last day of the year.
\item \code{date_range_md} Character vector.
Filter by month and day of the year (e.g., \code{"01-01"} to \code{"12-31"}). If
begin or end date is omitted then it is interpreted as the first or last
day of the year.
\item \verb{\{first|last\}_import_date_\{min|max\}} Date.
Filter by date record was imported/modified. Either a
\link[base:Dates]{Date} object or object that is coercible to the
\link[base:Dates]{Date} class by \link[lubridate]{as_date}, or the number
of seconds since 1970-01-01 00:00.00 UTC (the so-called UNIX epoch). Note
that this means that specifying a year, such as 2019, without a month and
day will be interpreted as 2019 seconds after midnight on Jan 1, 1970 and
not the year 2019.
}
}

\section{Quality}{

Filters related to quality of record:
\itemize{
\item \code{quality_issues}. Character.
Filter by the presence of record quality issues. One of \code{"without_issues"},
\code{"with_issues"} or \code{"both"}. Issues include any quality issues with the
record, the event, or the document. The default is \code{"without_issues"}
unless filtering by record, event or document ID or record annotation
status.
\item \code{requires_verification} Logical.
Show only records requiring verification (\code{TRUE}) or not requiring
verification (\code{FALSE}).
\item \code{collection_quality} Character vector.
Filter by one or more collection quality types. Must be one of
\code{"professional"}, \code{"hobbyist"} or \code{"amateur"}.
\item \code{record_reliability} Character vector.
Filter by the reliability of the record. Must be one or more of
\code{"reliable"}, \verb{"unassessed} or \code{"unreliable"}. Default is
\code{c("reliable", "unassessed")}.
\item \code{record_quality} Character vector.
Filter by the quality of the record. Must be one or more of
\code{"expert_verified"}, \code{"community_verified"}, \code{"unassessed"}, \code{"uncertain"},
or \code{"erroneous"}.
}
}

\section{Misc}{

Other filters:
\itemize{
\item \code{keywords} Character vector.
Filter by keywords.
\item \code{collection} Character vector or \code{finbif_collections()} data.frame.
Filter by collection. If a character vector can refer to collection ID,
collection name (in English) or abbreviated name.
Use \code{finbif_collections()} to see list of collections and metadata. Can
also use the results of a call to \code{finbif_collections()} directly to
filter records.
\item \code{subcollections} Logical.
If \code{TRUE} (default) include the subcollections of the collections
specified. If \code{FALSE} do not include subcollections.
\item \code{not_collection}  Character vector or \code{finbif_collections()} data.frame.
As for \code{collection}, but result will be the negation of the specified
collections.
\item \code{source} Character vector.
Filter by information system data source. Use \code{finbif_metadata()} to see
data source IDs names and descriptions.
\item \code{record_basis} Character vector.
Filter by basis of record. Use \code{finbif_metadata()} to see list of
record bases.
\item \code{superrecord_basis} Character vector.
Filter by superset of record basis. One or more of \code{"human_observation"},
\code{"machine_observation"}, or \code{"specimen"}.
\item \code{life_stage} Character vector.
Filter by organism life stage. Use \code{finbif_metadata()} to see list of
organism life stages.
\item \code{sex} Character vector.
Filter by organism sex and sex-related category name or code. Use
\code{finbif_metadata()} to see list of organism sexes and sex-related
categories and codes. If \code{"male"} or \code{"female"} is specified then records
returned will be those with sex specified as male or female respectively
and those records where the corresponding \verb{\{male|female\}_abundance > 1}.
\item \code{event_id} Character.
Filter by event (list of records, etc.) ID.
\item \code{document_id} Character.
Filter by the document (collection of events) ID of occurrences.
\item \code{record_id} Character.
\item \code{individual_id} Character.
Filter by individual (an individual organism) ID.
\item \code{abundance_min} Integer.
Filter by the minimum number of individual organisms in the record.
\item \code{abundance_max} Integer.
Filter by the maximum number of individual organisms in the record.
\item \code{type_specimen} Logical.
Filter by whether or not the record is a type specimen.
\item \code{wild_status} Character.
Filter by "wildness" status of records. One or more of \code{"wild"},
\code{"non_wild"} or \code{"unknown"}. Default is \code{c("wild", "unknown")}.
\item \code{is_breeding_location} Logical.
Filter by whether or not the occurrence is recorded at a known breeding
location.
\item \code{has_document_media} Logical.
Filter by whether there is media (images, video, audio, etc.) associated
with the records' document.
\item \code{has_event_media} Logical.
Filter by whether there is media (images, video, audio, etc.) associated
with the records' event.
\item \code{has_record_media} Logical.
Filter by whether there is media (images, video, audio, etc.) associated
with the record.
\item \code{has_media} Logical.
Filter by whether there is any media (images, video, audio, etc.)
associated with the record, its document or its event.
\item \code{event_observer_name} Character.
Filter by observer name.
\item \code{event_observer_id} Integer.
Filter by observer ID.
\item \code{restriction_reason} Character vector.
Filter by reason data has security restrictions. See
\code{finbif_metadata()} for a list of reasons data may have security
restrictions.
\item \code{restriction_level} Character vector.
Filter by data restriction level. See
\code{finbif_metadata()} for a list of the levels of data
restrictions.
\item \code{restricted} Logical.
Filter records by whether any data restrictions are in place (\code{TRUE}) or
not (\code{FALSE}).
\item \code{annotated} Logical.
Filter records that do (\code{TRUE}) or do not (\code{FALSE}) have annotations.
\item \code{unidentified} Logical.
Filter by whether the record has been identified to species level and
linked to the FinBIF taxon database (\code{FALSE}) or has not been identified to
species level reliably and linked to the taxon database (\code{TRUE}).
\item \code{taxon_census} Character vector.
Return records belonging to surveys or censuses of a given taxon or
taxonomic group. Specify the taxonomic group with a FinBIF taxon ID. Use
\code{finbif_check_taxa()} to find taxon IDs.
\item \verb{\{record|event|document\}_fact} Character vector.
Filter by record, event or document facts. Facts are key-value pairs of the
form \code{"<fact>=<value>"}. Value can be omitted in which case all records
with any value recorded for the specified fact will be returned.
\item \code{has_sample} Logical.
Record includes a sample or samples (e.g., a DNA sample or preparation).
\item \code{complete_list_type} Filter by complete list type. Records made during
monitoring that produces taxon lists for a given group of taxa (e.g.,
birds) can include all species observed with breeding status recorded for
each observed species (\code{all_species_and_breeding}), all species observed
without breeding status recorded for all species observed, all species
observed with or without breeding status recorded for all observed species
(\code{all_species}), or only some of the species observed (\code{incomplete}).
\item \code{complete_list_taxon_id} Filter by the taxon ID of the target group (e.g.,
birds) for a complete list.
}
}

