% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_dwc.R
\name{to_dwc}
\alias{to_dwc}
\alias{to_native}
\alias{from_schema}
\title{Convert variable names}
\usage{
to_dwc(...)

to_native(...)

from_schema(
  ...,
  to = c("native", "dwc", "short"),
  file = c("none", "citable", "lite")
)
}
\arguments{
\item{...}{Character. Variable names to convert. For \code{to_dwc} and \code{to_native}
the names must be in the opposite format. For \code{from_schema} the names must
be from the FinBIF schema (e.g., names returned by https://api.laji.fi) or
a FinBIF download file (citable or lite).}

\item{to}{Character. Type of variable names to convert to.}

\item{file}{Character. For variable names that are derived from a FinBIF
download file which type of file.}
}
\value{
Character vector.
}
\description{
Convert variable names to Darwin Core or FinBIF R package native style.
}
\examples{

to_dwc("record_id", "date_time", "scientific_name")
}
