% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_comparison_concept_network.R
\name{fst_cn_compare_plot}
\alias{fst_cn_compare_plot}
\title{Concept Network- Plot comparison Concept Network}
\usage{
fst_cn_compare_plot(
  edges,
  nodes,
  concepts,
  unique_lemmas,
  name = NULL,
  concept_colour = "#cd1719",
  unique_colour = "#4DAF4A",
  min_edge = NULL,
  max_edge = NULL,
  min_node = NULL,
  max_node = NULL,
  title_size = 20
)
}
\arguments{
\item{edges}{Output of `fst_cn_edges()`, dataframe of 'edges' connecting
two words.}

\item{nodes}{Output of `fst_cn_nodes()`, dataframe of relevant lemmas and
their associated pagerank.}

\item{concepts}{List of terms which have been searched for, separated by
commas.}

\item{unique_lemmas}{List of unique lemmas, output of `fst_cn_get_unique()`}

\item{name}{An optional "name" for the plot, default is `NULL` and a generic
title ("TextRank extracted keyword occurrences") will be used.}

\item{concept_colour}{Colour to display concept words, default is
`"indianred"`.}

\item{unique_colour}{Colour to display unique words, default is `"darkgreen"`.}

\item{min_edge}{A numeric value for the scale of the edges, the smallest
co_occurrence value for an edge across all Networks to be plotted together.}

\item{max_edge}{A numeric value for the scale of the edges, the largest
co_occurrence value for an edge across all Networks to be plotted together.}

\item{min_node}{A numeric value for the scale of the nodes, the smallest
pagerank value for a node across all Networks to be plotted together.}

\item{max_node}{A numeric value for the scale of the nodes, the largest
pagerank value for a node across all Networks to be plotted together.}

\item{title_size}{size to display plot title}
}
\value{
Plot of concept network with concept and unique words (nodes)
 highlighted.
}
\description{
Creates a Concept Network plot from a list of edges and nodes (and their
respective weights) which indicates unique words in this plot in comparison
to another Network.
}
\examples{
pos_filter <- c("NOUN", "VERB", "ADJ", "ADV")
e1 <- fst_cn_edges(fst_child, "lyödä", pos_filter = pos_filter)
e2 <- fst_cn_edges(fst_child, "lyöminen", pos_filter = pos_filter)
n1 <- fst_cn_nodes(fst_child, e1)
n2 <- fst_cn_nodes(fst_child, e2)
u <- fst_cn_get_unique_separate(n1, n2)

fst_cn_compare_plot(e1, n1, "lyödä", unique_lemma = u)
fst_cn_compare_plot(e2, n2, "lyöminen", u, unique_colour = "purple")
}
