\name{remp}
\alias{remp}
\title{Random Number Generation from an Empirical Distribution}
\description{
  Generates random numbers from a distribution created with empirical data
}
\usage{
 remp(n,obs=NULL)
}
\arguments{
   \item{n}{number of random observations to generate.}
  \item{obs}{vector of empirical observations.}
 
}
\details{
An empirical probability distribution is formed from empirical data with each observation 
having 1/T probabililty of selection, where T is the number of data points. The cumulative distribution 
function (cdf) is then created so that cumulative probability of the smallest observation = 0 and the 
largest observation = 1. Random values are generated by applying the probability integral transform to the 
empirical cdf using uniformly distributed random variable (U) on the interval[0,1]. If U corresponds directly to 
the cdf probability of a particular empirical observation, then the actual observation is selected.  If U falls between 
cdf probabilities of empirical observations, then an observation is obtained by linear interpolation.    
}
\value{random observation(s)}
\note{Jon Brodziak of the National Marine Fisheries Service, Honolulu, HI described this technique
 in his AGEPRO program.
}
\author{Gary A. Nelson, Massachusetts Division of Marine Fisheries \email{gary.nelson@state.ma.us}}
\examples{
# Striped bass recruits per spawning stock biomass ratios 
# for 2001-2011 from 2013 assessment
ratios<-c(799.22,794.78,969.81,1038.80,1101.45,1117.46,1126.16,
          1647.51,1882.30,1966.13,2189.25)
 # Select new recruits per SSB ratio for projection
 remp(1,ratios)
}
\keyword{misc}

