% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta.R
\name{EstMGFBetaBin}
\alias{EstMGFBetaBin}
\title{Estimating the shape parameters a and b for Beta-Binomial Distributon}
\usage{
EstMGFBetaBin(x,freq)
}
\arguments{
\item{x}{vector of binomial random variables}

\item{freq}{vector of frequencies}
}
\value{
The output of \code{EstMGFBetaBin} will produce a list format consisting

\code{a} shape parameter of beta distribution representing for alpha

\code{b} shape parameter of beta distribution representing for beta
}
\description{
The functions will estimate the shape parameters using the maximum log likelihood method and
moment generating function method for the beta-binomial distribution when the binomial
random variables and corresponding frequencies are given
}
\details{
\deqn{a,b > 0}
\deqn{x = 0,1,2,...}
\deqn{freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary error
messages will be provided to go further
}
\examples{
No.D.D=0:7        #assigning the random variables
Obs.fre.1=c(47,54,43,40,40,41,39,95)   #assigning the corresponding frequencies
#estimating the parameters using maximum log likelihood value and assigning it
parameters=suppressWarnings(bbmle::mle2(EstMLEBetaBin,start = list(a=0.1,b=0.1),
data = list(x=No.D.D,freq=Obs.fre.1)))
bbmle::coef(parameters)   #extracting the parameters

#estimating the parameters using moment generating function methods
EstMGFBetaBin(No.D.D,Obs.fre.1)

}
\references{
Young-Xu, Y. & Chan, K.A., 2008. Pooling overdispersed binomial data to estimate event rate. BMC medical
research methodology, 8(1), p.58.

Available at: \url{http://www.pubmedcentral.nih.gov/articlerender.fcgi?artid=2538541&tool=pmcentrez&rendertype=abstract} .

Trenkler, G., 1996. Continuous univariate distributions. Computational Statistics & Data Analysis, 21(1), p.119.

Available at: \url{http://linkinghub.elsevier.com/retrieve/pii/0167947396900158} .

Hughes, G., 1993. Using the Beta-Binomial Distribution to Describe Aggregated Patterns of Disease
Incidence. Phytopathology, 83(9), p.759.

Available at: \url{http://www.apsnet.org/publications/phytopathology/backissues/Documents/1993Abstracts/Phyto_83_759.htm}
}
\seealso{
\code{\link[bbmle]{mle2}}
}
