% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitbit_utils.R
\name{fitbit_data_type_by_date}
\alias{fitbit_data_type_by_date}
\title{Fitbit data retrieval for Blood Oxygen Saturation, Heart Rate Variability, Breathing Rate, Temperature and Cardio Fitness Score (or VO2 Max) by Date}
\usage{
fitbit_data_type_by_date(
  user_id,
  token,
  date,
  type = "spo2",
  plot = FALSE,
  show_nchar_case_error = 135
)
}
\arguments{
\item{user_id}{a character string specifying the encoded ID of the user. For instance '99xxxx' of the following URL 'https://www.fitbit.com/user/99xxxx' of the user's account corresponds to the 'user_id'}

\item{token}{a character string specifying the secret token that a user receives when registers a new application in https://dev.fitbit.com/apps}

\item{date}{a character string specifying a Date. For instance, the date '2021-12-31' where the input order is 'year-month-day'}

\item{type}{a character string specifying the fitbit data type. One of 'spo2', 'hrv', 'br', 'temp', 'cardioscore'. See the 'details' and 'references' sections for more information}

\item{plot}{a boolean. If TRUE then the minutes data will be plotted. This parameter is applicable only to the 'spo2' and 'hrv' types because they return minute data (see the details section for more information). The remaining types ('br', 'temp', 'cardioscore') return daily data.}

\item{show_nchar_case_error}{an integer that specifies the number of characters that will be returned in case on an error. The default value is 135 characters.}
}
\value{
a data.frame
}
\description{
Fitbit data retrieval for Blood Oxygen Saturation, Heart Rate Variability, Breathing Rate, Temperature and Cardio Fitness Score (or VO2 Max) by Date
}
\details{
\describe{
 \item{'spo2' (\emph{Blood Oxygen Saturation})}{This endpoint returns the SpO2 intraday data for a single date. SpO2 applies specifically to a user's "main sleep", which is the longest single period of time asleep on a given date. Spo2 values are calculated on a 5-minute exponentially-moving average}
 \item{'hrv' (\emph{Heart Rate Variability})}{This endpoint returns the Heart Rate Variability (HRV) intraday data for a single date. HRV data applies specifically to a user's "main sleep", which is the longest single period of time asleep on a given date. It measures the HRV rate at various times and returns Root Mean Square of Successive Differences (rmssd), Low Frequency (LF), High Frequency (HF), and Coverage data for a given measurement. Rmssd measures short-term variability in your heart rate while asleep. LF and HF capture the power in interbeat interval fluctuations within either high frequency or low frequency bands. Finally, coverage refers to data completeness in terms of the number of interbeat intervals}
 \item{'br' (\emph{Breathing Rate})}{This endpoint returns intraday breathing rate data for a specified date. It measures the average breathing rate throughout the day and categories your breathing rate by sleep stage. Sleep stages vary between light sleep, deep sleep, REM sleep, and full sleep}
 \item{'temp' (\emph{Temperature})}{This endpoint returns the Temperature (Skin) data for a single date. It only returns a value for dates on which the Fitbit device was able to record Temperature (skin) data. Temperature (Skin) data applies specifically to a user's "main sleep", which is the longest single period of time asleep on a given date}
 \item{'cardioscore' (\emph{Cardio Fitness Score or VO2 Max})}{The Cardio Fitness Score (also known as VO2 Max) endpoints are used for querying the maximum or optimum rate at which the user's heart, lungs, and muscles can effectively use oxygen during exercise}
 }

 If the 'type' parameter is one of 'spo2' or 'hrv' and the 'plot' parameter is set to TRUE then the results will appear as a line plot. In case of 'hrv' a multiplot with the following variables will be displayed:

\describe{
 \item{'rmssd'}{\emph{The Root Mean Square of Successive Differences (RMSSD) between heart beats. It measures short-term variability in the user's heart rate in milliseconds (ms)}}
 \item{'coverage'}{\emph{Data completeness in terms of the number of interbeat intervals}}
 \item{'hf'}{\emph{The power in interbeat interval fluctuations within the high frequency band (0.15 Hz - 0.4 Hz)}}
 \item{'lf'}{\emph{The power in interbeat interval fluctuations within the low frequency band (0.04 Hz - 0.15 Hz)}}
 }
}
\examples{

\dontrun{

require(fitbitViz)

USER_ID = '99xxxx'
token = 'my_long_web_api_token'

res_type = fitbit_data_type_by_date(user_id = USER_ID,
                                    token = token,
                                    date = '2022-10-12',
                                    type = 'spo2',
                                    plot = TRUE,
                                    show_nchar_case_error = 135)
res_type

}
}
\references{
https://dev.fitbit.com/build/reference/web-api/intraday/get-spo2-intraday-by-date/

https://dev.fitbit.com/build/reference/web-api/intraday/get-hrv-intraday-by-date/

https://dev.fitbit.com/build/reference/web-api/intraday/get-br-intraday-by-date/

https://dev.fitbit.com/build/reference/web-api/temperature/get-temperature-skin-summary-by-date

https://dev.fitbit.com/build/reference/web-api/cardio-fitness-score/get-vo2max-summary-by-date/
}
