% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_sigmoidal.R
\name{fweibull}
\alias{fweibull}
\title{Weibull vulnerability curve}
\usage{
fweibull(P, SX, PX, X = 50)
}
\arguments{
\item{P}{Water potential (positive-valued MPa)}

\item{SX}{Shape parameter}

\item{PX}{Water potential at X loss of conductivity.}

\item{X}{If 50, PX is the P50.}
}
\description{
The Weibull function, as re-parameterized by Ogle et al. (2009), which describes the relative conductivity as a function of the plant water potential. The relative conductivity (relK) is scaled to be 1 when water potential is zero. The slope of relK versus P at the inflection point can be calculated from the shape parameter (SX) as slope = -SX/100.
}
\examples{
curve(fweibull(x, SX=30, PX=2), from=0, to=5)
}
\references{
Ogle, K., Barber, J.J., Willson, C., Thompson, B., 2009. Hierarchical statistical modeling of xylem vulnerability to cavitation. New Phytologist 182, 541-554.
}

