% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{GOFTests}
\alias{GOFTests}
\alias{ks_test}
\alias{ad_test.distfun}
\alias{ad_test}
\alias{cvm_test.distfun}
\alias{cvm_test}
\title{Wrappers to compute goodness of fit test froms distfun objects}
\usage{
ks_test(distfun, x, ...)

\method{ad_test}{distfun}(distfun, x)

ad_test(distfun, x)

\method{cvm_test}{distfun}(distfun, x)

cvm_test(distfun, x)
}
\arguments{
\item{distfun}{a distfun object}

\item{x}{numeric vector}

\item{...}{arguments to be passed on to test function}
}
\value{
goodness of fit object
}
\description{
Wrappers to compute goodness of fit test froms distfun objects
}
\examples{
x <- rgamma(100, 1, 1)
fit <- fit_univariate(x, 'gamma')
ks_test(fit, x)
ad_test(fit, x)
cvm_test(fit, x)
}
