% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compounding-class.R
\name{implied_rate}
\alias{implied_rate}
\alias{implied_rate,Continuous,numeric,numeric-method}
\alias{implied_rate,Discrete,numeric,numeric-method}
\alias{implied_rate,Simple,numeric,numeric-method}
\alias{implied_rate,character,numeric,numeric-method}
\title{Implied rates}
\usage{
implied_rate(x, t, val, ...)
}
\arguments{
\item{x}{a Compounding object or a character with the compounding name.}

\item{t}{a numeric representing the term.}

\item{val}{a numeric representing the compounding factor.}

\item{...}{additional arguments. Currently unused.}
}
\value{
A numeric value that represents a spot rate.
}
\description{
Computes implied rates to compounding factors.
}
\details{
If the \code{x} argument is a \code{character} with a valid compounding name
(\code{simple}, \code{discrete}, \code{continuous}) the function
instanciates a Compounding object and then computes the implied rate
for the given compounding values and terms.
}
\examples{
implied_rate("simple", 2, 1.1)
implied_rate("discrete", 2, 1.1025)
implied_rate("continuous", 2, 1.105170918)

comp <- compounding("discrete")
compound(comp, 0.06, 2) # equals (1 + 0.06) ^ 2 = 1.1236
implied_rate(comp, 1.1236, 2) # equals 0.06
}
