% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_study.R
\name{run_es}
\alias{run_es}
\title{Run Event Study with Fixed Effects}
\usage{
run_es(
  data,
  outcome,
  treatment,
  time,
  timing,
  lead_range,
  lag_range,
  covariates = NULL,
  fe,
  cluster = NULL,
  baseline = -1,
  interval = 1
)
}
\arguments{
\item{data}{A dataframe containing the panel dataset.}

\item{outcome}{The outcome variable, specified unquoted. You may use a raw variable name
(e.g., `y`) or a transformation (e.g., `log(y)`).}

\item{treatment}{The binary treatment indicator (unquoted). Typically equals 1 in and after the treated period, 0 otherwise.}

\item{time}{The time variable (unquoted). Used to calculate the relative timing.}

\item{timing}{The time period when the treatment occurs for the treated units.}

\item{lead_range}{Number of pre-treatment periods to include as leads (e.g., 5 = `lead5`, `lead4`, ..., `lead1`).}

\item{lag_range}{Number of post-treatment periods to include as lags (e.g., 3 = `lag0`, `lag1`, `lag2`, `lag3`).}

\item{covariates}{Optional covariates to include in the regression. Must be supplied as a one-sided formula (e.g., `~ x1 + x2`).}

\item{fe}{Fixed effects to control for unobserved heterogeneity. Must be a one-sided formula (e.g., `~ id + year`).}

\item{cluster}{Clustering specification for robust standard errors. Accepts either:
\itemize{
  \item a character vector of column names (e.g., `c("id", "year")`), or
  \item a one-sided formula (e.g., `~ id + year` or `~ id^year`).
}
Cluster variables are internally re-evaluated after filtering for the estimation window.}

\item{baseline}{The relative time (e.g., `-1`) to use as the reference period.
The corresponding dummy variable will be excluded from the regression and added manually to the results with estimate 0.
Must lie within the specified `lead_range` and `lag_range`. If not, an error will be thrown.}

\item{interval}{The interval between time periods (e.g., use `5` for 5-year spaced panel). Default is `1`.}
}
\value{
A tidy dataframe with the event study regression results, containing:
\itemize{
  \item `term`: Name of the lead or lag dummy variable.
  \item `estimate`: Coefficient estimate.
  \item `std.error`: Standard error.
  \item `statistic`: t-statistic.
  \item `p.value`: p-value.
  \item `conf_high`: Upper bound of 95% confidence interval.
  \item `conf_low`: Lower bound of 95% confidence interval.
  \item `relative_time`: Time scaled relative to the treatment.
  \item `is_baseline`: Logical indicator for the baseline term (equals `TRUE` only for the excluded dummy).
}
}
\description{
This function performs an event study using fixed effects regression based on a panel dataset.
It generates dummy variables for each lead and lag period relative to the treatment timing,
applies optional covariates and fixed effects, and estimates the model using `fixest::feols`.
}
\details{
This function is intended for difference-in-differences or event study designs with panel data.
It automatically:
\itemize{
  \item computes relative time: \code{(time - timing) / interval},
  \item generates dummy variables for specified leads and lags,
  \item removes the baseline term from estimation and appends it back post-estimation,
  \item uses `fixest::feols()` for fast and flexible estimation.
}
Both fixed effects and clustering are fully supported.
}
\examples{
\dontrun{
# Assume df is a panel dataset with variables: id, year, y, treat, x1, x2, var1, var2

# Specifying two-way clustering over var1 and var2 using a character vector:
run_es(
  data       = df,
  outcome    = y,
  treatment  = treat,
  time       = year,
  timing     = 2005,
  lead_range = 2,
  lag_range  = 2,
  covariates = ~ x1 + x2,
  fe         = ~ id + year,
  cluster    = c("var1", "var2"),
  interval   = 1
)

# Specifying two-way clustering over var1 and var2 using a one-sided formula:
run_es(
  data       = df,
  outcome    = y,
  treatment  = treat,
  time       = year,
  timing     = 2005,
  lead_range = 2,
  lag_range  = 2,
  covariates = ~ x1 + x2,
  fe         = ~ id + year,
  cluster    = ~ var1 + var2,
  interval   = 1
)

# Using an interaction in the clustering specification:
run_es(
  data       = df,
  outcome    = y,
  treatment  = treat,
  time       = year,
  timing     = 2005,
  lead_range = 2,
  lag_range  = 2,
  covariates = ~ x1 + x2,
  fe         = ~ id + year,
  cluster    = ~ var1^var2,
  interval   = 1
)
}
}
