% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest_multi.R
\name{models}
\alias{models}
\title{Extracts the models tree from a \code{fixest_multi} object}
\usage{
models(x, simplify = FALSE)
}
\arguments{
\item{x}{A \code{fixest_multi} object, obtained from a \code{fixest} estimation leading to multiple results.}

\item{simplify}{Logical, default is \code{FALSE}. The default behavior is to display all the meta information, even if they are identical across models. By using \code{simplify = TRUE}, only the information with some variation is kept.}
}
\value{
It returns a \code{data.frame} whose first column (named \code{id}) is the index of the models and the other columns contain the information specific to each model (e.g. which sample, which RHS,  which dependent variable, etc).
}
\description{
Extracts the meta information on all the models contained in a \code{fixest_multi} estimation.
}
\examples{

# a multiple estimation
base = setNames(iris, c("y", "x1", "x2", "x3", "species"))
est = feols(y ~ csw(x.[, 1:3]), base, fsplit = ~species)

# All the meta information
models(est)

# Illustration: Why use simplify
est_sub = est[sample = 2]
models(est_sub)
models(est_sub, simplify = TRUE)



}
